/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.bootstrap.internal.wrapper;

import static java.util.Objects.requireNonNull;
import static org.mule.tooling.client.internal.serialization.SerializationUtils.deserialize;
import static org.mule.tooling.client.internal.serialization.SerializationUtils.serialize;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.extension.ExtensionModelService;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;

import com.google.common.collect.ImmutableList;

import java.io.File;
import java.util.List;
import java.util.Optional;

/**
 * Client side implementation for {@link ExtensionModelService} that uses reflection and works as a bridge
 * between {@link ClassLoader classLoaders}.
 *
 * @since 1.0
 */
public class ExtensionModelServiceWrapper implements ExtensionModelService {

  private Dispatcher dispatcher;

  public ExtensionModelServiceWrapper(Dispatcher dispatcher) {
    requireNonNull(dispatcher, "dispatcher cannot be null");

    this.dispatcher = dispatcher;
  }

  @Override
  public Optional<ExtensionModel> loadExtensionModel(ArtifactDescriptor pluginDescriptor) {
    String result = (String) dispatcher.dispatchRemoteMethod("loadExtensionModel",
                                                             ImmutableList.of(ArtifactDescriptor.class),
                                                             ImmutableList.of(serialize(pluginDescriptor)));
    return deserialize(result);
  }

  @Override
  public Optional<ExtensionModel> loadExtensionModel(File plugin) {
    String result = (String) dispatcher.dispatchRemoteMethod("loadExtensionModel",
                                                             ImmutableList.of(File.class),
                                                             ImmutableList.of(serialize(plugin)));
    return deserialize(result);
  }

  @Override
  public Optional<String> loadExtensionSchema(ArtifactDescriptor pluginDescriptor) {
    String result = (String) dispatcher.dispatchRemoteMethod("loadExtensionSchema",
                                                             ImmutableList.of(ArtifactDescriptor.class),
                                                             ImmutableList.of(serialize(pluginDescriptor)));
    return deserialize(result);
  }

  @Override
  public Optional<String> loadExtensionSchema(File plugin) {
    String result = (String) dispatcher.dispatchRemoteMethod("loadExtensionSchema",
                                                             ImmutableList.of(File.class),
                                                             ImmutableList.of(serialize(plugin)));
    return deserialize(result);
  }

  @Override
  public List<ExtensionModel> loadMuleExtensionModels() {
    String result = (String) dispatcher.dispatchRemoteMethod("loadMuleExtensionModels");
    return deserialize(result);
  }

}
