/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.bootstrap.internal.wrapper;

import static java.util.Objects.requireNonNull;
import static org.mule.tooling.client.internal.serialization.SerializationUtils.deserialize;
import static org.mule.tooling.client.internal.serialization.SerializationUtils.serialize;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.metadata.MetadataKeysContainer;
import org.mule.tooling.client.api.metadata.MetadataKeysRequest;
import org.mule.tooling.client.api.metadata.MetadataResult;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;

import com.google.common.collect.ImmutableList;

/**
 * Client side implementation for {@link MetadataService} that uses reflection and works as a bridge
 * between {@link ClassLoader classLoaders}.
 *
 * @since 1.0
 */
public class MetadataServiceWrapper implements MetadataService {

  private Dispatcher dispatcher;

  public MetadataServiceWrapper(Dispatcher dispatcher) {
    requireNonNull(dispatcher, "dispatcher cannot be null");

    this.dispatcher = dispatcher;
  }

  @Override
  public MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataKeysRequest metadataKeysRequest)
      throws ServiceUnavailableException {
    String result = (String) dispatcher.dispatchRemoteMethod("getMetadataKeys",
                                                             metadataKeysRequest.getRequestTimeout(),
                                                             ImmutableList.of(MetadataKeysRequest.class),
                                                             ImmutableList.of(serialize(metadataKeysRequest)));
    return deserialize(result);
  }

}
