/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.vdurmont.semver4j.Semver;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionScheme;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.VersionRangeResult;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.extension.model.MuleVersion;
import org.mule.tooling.client.bootstrap.api.DynamicToolingVersionResolverConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingVersionResolver;
import org.mule.tooling.client.bootstrap.api.ToolingVersionResolverConfiguration;
import org.mule.tooling.client.bootstrap.api.UpdatePolicy;
import org.mule.tooling.client.bootstrap.internal.DefaultToolingVersion;
import org.mule.tooling.client.bootstrap.internal.UpdatePolicyUtils;

public class DefaultToolingVersionResolver
implements ToolingVersionResolver,
DynamicToolingVersionResolverConfiguration {
    private LoadingCache<String, ToolingVersionResolver.ToolingVersion> cachedRemoteVersions;
    private ToolingVersionResolverConfiguration configuration;
    private MavenClient mavenClient;
    private VersionScheme versionScheme = new GenericVersionScheme();

    public DefaultToolingVersionResolver(ToolingVersionResolverConfiguration configuration, MavenClient mavenClient) {
        Objects.requireNonNull(configuration, "configuration cannot be null");
        Objects.requireNonNull(mavenClient, "mavenClient cannot be null");
        this.configuration = configuration;
        this.mavenClient = mavenClient;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        cacheBuilder.refreshAfterWrite(UpdatePolicyUtils.toMinutes(this.configuration.remoteVersionUpdatePolicy()), TimeUnit.MINUTES);
        this.cachedRemoteVersions = cacheBuilder.build((CacheLoader)new CacheLoader<String, ToolingVersionResolver.ToolingVersion>(){

            public ToolingVersionResolver.ToolingVersion load(String muleVersion) throws Exception {
                return new DefaultToolingVersion(DefaultToolingVersionResolver.this.fetchLatestToolingRuntimeClient(muleVersion), null);
            }

            public ListenableFuture<ToolingVersionResolver.ToolingVersion> reload(String muleVersion, ToolingVersionResolver.ToolingVersion oldValue) throws Exception {
                ToolingVersionResolver.ToolingVersion refreshed = oldValue;
                String newValue = DefaultToolingVersionResolver.this.fetchLatestToolingRuntimeClient(muleVersion);
                if (!newValue.equals(oldValue)) {
                    refreshed = new DefaultToolingVersion(newValue, oldValue.getVersion());
                }
                return Futures.immediateFuture((Object)refreshed);
            }
        });
    }

    @Override
    public DynamicToolingVersionResolverConfiguration getToolingVersionResolverConfiguration() {
        return this;
    }

    @Override
    public ToolingVersionResolver.ToolingVersion resolve(String muleVersion) {
        try {
            for (String mappedMuleVersion : this.configuration.mappings().keySet()) {
                VersionConstraint versionConstraint = this.versionScheme.parseVersionConstraint(mappedMuleVersion);
                if (!versionConstraint.containsVersion(this.versionScheme.parseVersion(muleVersion))) continue;
                return new DefaultToolingVersion(this.configuration.mappings().get(mappedMuleVersion), null);
            }
            MuleVersion parsedVersion = new MuleVersion(muleVersion);
            int major = parsedVersion.getMajor();
            int minor = parsedVersion.getMinor();
            return (ToolingVersionResolver.ToolingVersion)this.cachedRemoteVersions.get((Object)String.format("%s.%s", major, minor));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new ToolingException(String.format("Error while reading mappings: {}", this.configuration.mappings()), (Throwable)e);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IllegalStateException.class);
            throw new ToolingException(String.format("Error while getting latest version from Maven configuration: {}", this.configuration.mavenConfiguration()), e.getCause());
        }
    }

    private String fetchLatestToolingRuntimeClient(String muleVersion) {
        String versionRange = this.toVersionRange(muleVersion);
        VersionRangeResult versionRangeResult = this.mavenClient.resolveVersionRange(new BundleDescriptor.Builder().setGroupId("org.mule.tooling").setArtifactId("mule-runtime-tooling-client").setVersion(versionRange).build());
        if (versionRangeResult.getVersions().isEmpty()) {
            throw new IllegalStateException(String.format("There is no version mapped or available of Tooling Runtime Client for: '%s'", versionRange));
        }
        ListIterator listIterator = versionRangeResult.getVersions().listIterator(versionRangeResult.getVersions().size());
        while (listIterator.hasPrevious()) {
            Semver semver = new Semver((String)listIterator.previous(), Semver.SemverType.STRICT);
            if (semver.getSuffixTokens().length == 0) {
                return semver.getOriginalValue();
            }
            if (!this.configuration.allowedSuffixes().containsAll(Arrays.asList(semver.getSuffixTokens()))) continue;
            return semver.getOriginalValue();
        }
        throw new IllegalStateException(String.format("Resolved versions using Maven: '%s' for: '%s' don't match any allowed suffixes: %s", versionRangeResult.getVersions(), versionRange, this.configuration.allowedSuffixes()));
    }

    private String toVersionRange(String muleVersion) {
        MuleVersion parsedVersion = new MuleVersion(muleVersion);
        int major = parsedVersion.getMajor();
        int minor = parsedVersion.getMinor();
        return String.format("[%s.%s.0,%s.%s.0)", major, minor, major, minor + 1);
    }

    @Override
    public Map<String, String> dynamicMappings() {
        return this.cachedRemoteVersions.asMap().entrySet().stream().collect(Collectors.toMap(e -> this.toVersionRange((String)e.getKey()), e -> ((ToolingVersionResolver.ToolingVersion)e.getValue()).getVersion()));
    }

    @Override
    public MavenConfiguration mavenConfiguration() {
        return this.configuration.mavenConfiguration();
    }

    @Override
    public UpdatePolicy remoteVersionUpdatePolicy() {
        return this.configuration.remoteVersionUpdatePolicy();
    }

    @Override
    public List<String> allowedSuffixes() {
        return this.configuration.allowedSuffixes();
    }

    @Override
    public LinkedHashMap<String, String> mappings() {
        return this.configuration.mappings();
    }
}

