/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.ToolingRuntimeClientBuilderFactory;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.bootstrap.internal.wrapper.BuilderWrapper;

public class ToolingRuntimeClientBuilderFactoryWrapper
implements ToolingRuntimeClientBuilderFactory,
Disposable {
    private String muleVersion;
    private ClassLoader toolingClassLoader;
    private Dispatcher dispatcher;
    private MavenConfiguration mavenConfiguration;

    public ToolingRuntimeClientBuilderFactoryWrapper(String muleVersion, ClassLoader toolingClassLoader, ExecutorService executorService, MavenConfiguration mavenConfiguration) {
        Objects.requireNonNull(muleVersion, "muleVersion cannot be null");
        Objects.requireNonNull(toolingClassLoader, "toolingClassLoader cannot be null");
        Objects.requireNonNull(executorService, "executorService cannot be null");
        Objects.requireNonNull(mavenConfiguration, "mavenConfiguration cannot be null");
        this.muleVersion = muleVersion;
        this.toolingClassLoader = toolingClassLoader;
        this.dispatcher = new Dispatcher(this.discoverToolingRuntimeClientFactory(), toolingClassLoader, executorService);
        this.mavenConfiguration = mavenConfiguration;
    }

    private Object discoverToolingRuntimeClientFactory() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.toolingClassLoader);
            Object obj = this.toolingClassLoader.loadClass("org.mule.tooling.client.internal.DefaultToolingRuntimeClientFactory").getConstructor(String.class).newInstance(this.muleVersion);
            return obj;
        }
        catch (NoSuchMethodException e) {
            try {
                ServiceLoader<?> serviceLoader = ServiceLoader.load(this.toolingClassLoader.loadClass(ToolingRuntimeClientBuilderFactory.class.getName()), this.toolingClassLoader);
                if (!serviceLoader.iterator().hasNext()) {
                    throw new IllegalStateException("No service found for: '" + ToolingRuntimeClientBuilderFactory.class.getName() + "'");
                }
                Object obj = serviceLoader.iterator().next();
                return obj;
            }
            catch (ClassNotFoundException e1) {
                throw new IllegalStateException(String.format("ClassLoader for Tooling was not correctly created as there is no implementation of %s", ToolingRuntimeClientBuilderFactory.class.getName()), e1);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while creating the implementation of %s", ToolingRuntimeClientBuilderFactory.class.getName()), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void dispose() {
        this.dispatcher.dispatchRemoteMethod("dispose");
    }

    public ToolingRuntimeClient.Builder create() {
        Object builderTarget = this.dispatcher.dispatchRemoteMethod("create");
        BuilderWrapper builder = new BuilderWrapper(this.toolingClassLoader, this.dispatcher.newReflectionInvoker(builderTarget));
        builder.withMavenConfiguration(this.mavenConfiguration);
        return builder;
    }
}

