/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import org.apache.commons.lang3.ClassUtils;
import sun.net.www.protocol.jar.Handler;
import sun.net.www.protocol.jar.JarURLConnection;

public class ToolingClassLoader
extends URLClassLoader {
    private String muleVersion;
    private String toolingVersion;
    private int bootstrapObjectId;

    public ToolingClassLoader(String muleVersion, String toolingVersion, int bootstrapObjectId, URL[] urls, ClassLoader parent) {
        super(urls, parent, new NonCachingURLStreamHandlerFactory());
        this.muleVersion = muleVersion;
        this.toolingVersion = toolingVersion;
        this.bootstrapObjectId = bootstrapObjectId;
    }

    public String toString() {
        return String.format("%s{muleVersion=%s, toolingVersion=%s, bootstrapObjectId=%s, objectId=%s}", ClassUtils.getShortClassName(this.getClass()), this.muleVersion, this.toolingVersion, this.bootstrapObjectId, System.identityHashCode(this));
    }

    private static class NonCachingJarResourceURLStreamHandler
    extends Handler {
        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            JarURLConnection c = new JarURLConnection(u, this);
            ((URLConnection)c).setUseCaches(false);
            return c;
        }
    }

    protected static class NonCachingURLStreamHandlerFactory
    implements URLStreamHandlerFactory {
        protected NonCachingURLStreamHandlerFactory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            return new NonCachingJarResourceURLStreamHandler();
        }
    }
}

