/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.ToolingRuntimeClientBuilderFactory;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.bootstrap.internal.wrapper.BuilderWrapper;
import org.mule.tooling.client.internal.serialization.KryoClientSerializer;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.serialization.XStreamClientSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolingRuntimeClientBuilderFactoryWrapper
implements ToolingRuntimeClientBuilderFactory,
Disposable {
    private static Logger LOGGER = LoggerFactory.getLogger(ToolingRuntimeClientBuilderFactoryWrapper.class);
    private String muleVersion;
    private ClassLoader toolingClassLoader;
    private Dispatcher dispatcher;
    private Serializer serializer;
    private MavenConfiguration mavenConfiguration;

    public ToolingRuntimeClientBuilderFactoryWrapper(String muleVersion, ClassLoader toolingClassLoader, ExecutorService executorService, MavenConfiguration mavenConfiguration) {
        Objects.requireNonNull(muleVersion, "muleVersion cannot be null");
        Objects.requireNonNull(toolingClassLoader, "toolingClassLoader cannot be null");
        Objects.requireNonNull(executorService, "executorService cannot be null");
        Objects.requireNonNull(mavenConfiguration, "mavenConfiguration cannot be null");
        this.muleVersion = muleVersion;
        this.toolingClassLoader = toolingClassLoader;
        Object toolingRuntimeClientFactory = this.discoverToolingRuntimeClientFactory();
        this.serializer = this.discoverSerialization(toolingRuntimeClientFactory);
        this.dispatcher = new Dispatcher(toolingRuntimeClientFactory, toolingClassLoader, executorService);
        this.mavenConfiguration = mavenConfiguration;
    }

    private Serializer discoverSerialization(Object toolingRuntimeClientFactory) {
        try {
            toolingRuntimeClientFactory.getClass().getMethod("setSerialization", String.class).invoke(toolingRuntimeClientFactory, KryoClientSerializer.NAME);
            LOGGER.info("Using Kryo serialization");
            return new KryoClientSerializer();
        }
        catch (NoSuchMethodException e) {
            LOGGER.info("Using xStream serialization, as API supports Kryo but not the bootstrapped implementation");
            return new XStreamClientSerializer();
        }
        catch (IllegalAccessException e) {
            throw new ToolingException("Error while discovering serialization", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ToolingException("Error while discovering serialization", (Throwable)e);
        }
    }

    private Object discoverToolingRuntimeClientFactory() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.toolingClassLoader);
            Object obj = this.toolingClassLoader.loadClass("org.mule.tooling.client.internal.DefaultToolingRuntimeClientFactory").getConstructor(String.class).newInstance(this.muleVersion);
            return obj;
        }
        catch (NoSuchMethodException e) {
            try {
                ServiceLoader<?> serviceLoader = ServiceLoader.load(this.toolingClassLoader.loadClass(ToolingRuntimeClientBuilderFactory.class.getName()), this.toolingClassLoader);
                if (!serviceLoader.iterator().hasNext()) {
                    throw new IllegalStateException("No service found for: '" + ToolingRuntimeClientBuilderFactory.class.getName() + "'");
                }
                Object obj = serviceLoader.iterator().next();
                return obj;
            }
            catch (ClassNotFoundException e1) {
                throw new IllegalStateException(String.format("ClassLoader for Tooling was not correctly created as there is no implementation of %s", ToolingRuntimeClientBuilderFactory.class.getName()), e1);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while creating the implementation of %s", ToolingRuntimeClientBuilderFactory.class.getName()), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void dispose() {
        this.dispatcher.dispatchRemoteMethod("dispose");
    }

    public ToolingRuntimeClient.Builder create() {
        Object builderTarget = this.dispatcher.dispatchRemoteMethod("create");
        BuilderWrapper builder = new BuilderWrapper(this.toolingClassLoader, this.dispatcher.newReflectionInvoker(builderTarget), this.serializer);
        builder.withMavenConfiguration(this.mavenConfiguration);
        return builder;
    }
}

