/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolverFactory;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolverService;
import org.mule.tooling.client.api.artifact.dsl.request.DslSyntaxResolverFactoryRequest;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.connection.ConnectionProviderModel;
import org.mule.tooling.client.api.extension.model.construct.ConstructModel;
import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.internal.serialization.Serializer;

public class DslSyntaxResolverServiceWrapper
implements DslSyntaxResolverService {
    private Dispatcher dispatcher;
    private Serializer serializer;

    public DslSyntaxResolverServiceWrapper(Dispatcher dispatcher, Serializer serializer) {
        Objects.requireNonNull(dispatcher, "dispatcher cannot be null");
        Objects.requireNonNull(serializer, "serializer cannot be null");
        this.dispatcher = dispatcher;
        this.serializer = serializer;
    }

    public DslSyntaxResolverFactory getDslSyntaxResolverFactory(DslSyntaxResolverFactoryRequest request) {
        Object dslSyntaxResolverFactoryTarget = this.dispatcher.dispatchRemoteMethod("getDslSyntaxResolverFactory", (List<Class>)ImmutableList.of(DslSyntaxResolverFactoryRequest.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)request)));
        return new DslSyntaxResolverFactoryWrapper(this.dispatcher.newReflectionInvoker(dslSyntaxResolverFactoryTarget));
    }

    private class DslSyntaxResolverFactoryWrapper
    implements DslSyntaxResolverFactory {
        private Dispatcher dispatcher;

        public DslSyntaxResolverFactoryWrapper(Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }

        public void dispose() {
            this.dispatcher.dispatchRemoteMethod("dispose");
        }

        public DslSyntaxResolver createDslResolver(ExtensionModel extensionModel) {
            Object dslSyntaxResolverTarget = this.dispatcher.dispatchRemoteMethod("createDslResolver", (List<Class>)ImmutableList.of(ExtensionModel.class), (List<String>)ImmutableList.of((Object)DslSyntaxResolverServiceWrapper.this.serializer.serialize((Object)extensionModel)));
            return new DslSyntaxResolverWrapper(this.dispatcher.newReflectionInvoker(dslSyntaxResolverTarget));
        }

        private class DslSyntaxResolverWrapper
        implements DslSyntaxResolver {
            private Dispatcher dispatcher;

            public DslSyntaxResolverWrapper(Dispatcher dispatcher) {
                this.dispatcher = dispatcher;
            }

            public void dispose() {
                this.dispatcher.dispatchRemoteMethod("dispose");
            }

            public DslElementSyntax resolve(ConfigurationModel component) {
                return (DslElementSyntax)this.dispatchRemoteMethod("resolve", component, ConfigurationModel.class);
            }

            public DslElementSyntax resolve(ConnectionProviderModel component) {
                return (DslElementSyntax)this.dispatchRemoteMethod("resolve", component, ConnectionProviderModel.class);
            }

            public DslElementSyntax resolve(ConstructModel component) {
                return (DslElementSyntax)this.dispatchRemoteMethod("resolve", component, ConstructModel.class);
            }

            public DslElementSyntax resolve(OperationModel component) {
                return (DslElementSyntax)this.dispatchRemoteMethod("resolve", component, OperationModel.class);
            }

            public DslElementSyntax resolve(SourceModel component) {
                return (DslElementSyntax)this.dispatchRemoteMethod("resolve", component, SourceModel.class);
            }

            public Optional<DslElementSyntax> resolve(MetadataType type) {
                return this.dispatchRemoteMethodOptionalReturn("resolve", type, MetadataType.class);
            }

            public Set<ObjectType> getSubTypes(ObjectType type) {
                return (Set)this.dispatchRemoteMethod("getSubTypes", type, ObjectType.class);
            }

            private <T> T dispatchRemoteMethod(String method, Object parameter, Class parameterType) {
                return (T)DslSyntaxResolverServiceWrapper.this.serializer.deserialize(this.doDispatch(method, parameter, parameterType));
            }

            private Optional<DslElementSyntax> dispatchRemoteMethodOptionalReturn(String method, Object parameter, Class parameterType) {
                return (Optional)DslSyntaxResolverServiceWrapper.this.serializer.deserialize(this.doDispatch(method, parameter, parameterType));
            }

            private String doDispatch(String method, Object parameter, Class parameterType) {
                return (String)this.dispatcher.dispatchRemoteMethod(method, (List<Class>)ImmutableList.of((Object)parameterType), (List<String>)ImmutableList.of((Object)DslSyntaxResolverServiceWrapper.this.serializer.serialize(parameter)));
            }
        }
    }
}

