/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.datasense.DataSenseService;
import org.mule.tooling.client.api.dataweave.DataWeaveService;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.api.value.provider.ValueProviderService;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.bootstrap.internal.wrapper.ConnectivityTestingServiceWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.DataSenseServiceWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.DataWeaveServiceWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.MetadataServiceWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.ValueProviderServiceWrapper;
import org.mule.tooling.client.internal.serialization.Serializer;

public class ToolingArtifactWrapper
implements ToolingArtifact {
    private Dispatcher dispatcher;
    private Serializer serializer;

    public ToolingArtifactWrapper(Dispatcher dispatcher, Serializer serializer) {
        Objects.requireNonNull(dispatcher, "dispatcher cannot be null");
        Objects.requireNonNull(serializer, "serializer cannot be null");
        this.dispatcher = dispatcher;
        this.serializer = serializer;
    }

    public Optional<ToolingArtifact> getParent() {
        Optional parentTarget = (Optional)this.dispatcher.dispatchRemoteMethod("getParent");
        return parentTarget.map(target -> new ToolingArtifactWrapper(this.dispatcher.newReflectionInvoker(target), this.serializer));
    }

    public String getId() {
        return (String)this.serializer.deserialize((String)this.dispatcher.dispatchRemoteMethod("id"));
    }

    public Map<String, String> getProperties() {
        return (Map)this.serializer.deserialize((String)this.dispatcher.dispatchRemoteMethod("getProperties"));
    }

    public ConnectivityTestingService connectivityTestingService() {
        Object connectivityTestingServiceTarget = this.dispatcher.dispatchRemoteMethod("connectivityTestingService");
        return new ConnectivityTestingServiceWrapper(this.dispatcher.newReflectionInvoker(connectivityTestingServiceTarget), this.serializer);
    }

    public MetadataService metadataService() {
        Object metadataServiceTarget = this.dispatcher.dispatchRemoteMethod("metadataService");
        return new MetadataServiceWrapper(this.dispatcher.newReflectionInvoker(metadataServiceTarget), this.serializer);
    }

    public DataSenseService dataSenseService() {
        Object dataSenseServiceTarget = this.dispatcher.dispatchRemoteMethod("dataSenseService");
        return new DataSenseServiceWrapper(this.dispatcher.newReflectionInvoker(dataSenseServiceTarget), this.serializer);
    }

    public DataWeaveService dataWeaveService() {
        Object dataWeaveServiceTarget = this.dispatcher.dispatchRemoteMethod("dataWeaveService");
        return new DataWeaveServiceWrapper(this.dispatcher.newReflectionInvoker(dataWeaveServiceTarget), this.serializer);
    }

    public ValueProviderService valueProviderService() {
        Object valueProviderServiceTarget = this.dispatcher.dispatchRemoteMethod("valueProviderService");
        return new ValueProviderServiceWrapper(this.dispatcher.newReflectionInvoker(valueProviderServiceTarget), this.serializer);
    }

    public void dispose() {
        this.dispatcher.dispatchRemoteMethod("dispose");
    }
}

