/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal;

import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import java.net.URI;
import java.util.Optional;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.bootstrap.api.ExecutorServiceConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;
import org.mule.tooling.client.internal.util.Preconditions;

public class DefaultToolingRuntimeClientBootstrapConfigurationBuilder
implements ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder {
    private String muleVersion;
    private String toolingVersion;
    private MavenConfiguration mavenConfiguration;
    private URI log4jConfiguration;
    private ExecutorServiceConfiguration executorServiceConfiguration;

    @Override
    public ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder muleVersion(String muleVersion) {
        this.muleVersion = muleVersion;
        return this;
    }

    @Override
    public ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder toolingVersion(String toolingVersion) {
        this.toolingVersion = toolingVersion;
        return this;
    }

    @Override
    public ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder mavenConfiguration(MavenConfiguration mavenConfiguration) {
        this.mavenConfiguration = mavenConfiguration;
        return this;
    }

    @Override
    public ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder log4jConfiguration(URI log4jConfiguration) {
        this.log4jConfiguration = log4jConfiguration;
        return this;
    }

    @Override
    public ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder executorServiceConfiguration(ExecutorServiceConfiguration executorServiceConfiguration) {
        this.executorServiceConfiguration = executorServiceConfiguration;
        return this;
    }

    @Override
    public ToolingRuntimeClientBootstrapConfiguration build() {
        return new DefaultToolingRuntimeClientBootstrapConfiguration(this.muleVersion, this.toolingVersion, this.mavenConfiguration, this.log4jConfiguration, this.executorServiceConfiguration);
    }

    private static class DefaultToolingRuntimeClientBootstrapConfiguration
    implements ToolingRuntimeClientBootstrapConfiguration {
        private String muleVersion;
        private String toolingVersion;
        private MavenConfiguration mavenConfiguration;
        private URI log4jConfiguration;
        private ExecutorServiceConfiguration executorServiceConfiguration;

        DefaultToolingRuntimeClientBootstrapConfiguration(String muleVersion, String toolingVersion, MavenConfiguration mavenConfiguration, URI log4jConfiguration, ExecutorServiceConfiguration executorServiceConfiguration) {
            Preconditions.checkNotNull((Object)muleVersion, (String)"muleVersion cannot be null");
            Preconditions.checkNotNull((Object)toolingVersion, (String)"toolingVersion cannot be null");
            Preconditions.checkNotNull((Object)mavenConfiguration, (String)"mavenConfiguration cannot be null");
            Preconditions.checkState((boolean)this.validateSemanticVersioning(muleVersion), (String)String.format("muleVersion '%s' has to be defined with 'major.minor.patch' format", muleVersion));
            Preconditions.checkState((boolean)this.validateSemanticVersioning(toolingVersion), (String)String.format("toolingVersion '%s' has to be defined with 'major.minor.patch' format", toolingVersion));
            this.muleVersion = muleVersion;
            this.toolingVersion = toolingVersion;
            this.mavenConfiguration = mavenConfiguration;
            this.log4jConfiguration = log4jConfiguration;
            this.executorServiceConfiguration = executorServiceConfiguration;
        }

        private boolean validateSemanticVersioning(String version) {
            try {
                new Semver(version, Semver.SemverType.STRICT);
                return true;
            }
            catch (SemverException e) {
                return false;
            }
        }

        @Override
        public String muleVersion() {
            return this.muleVersion;
        }

        @Override
        public String toolingVersion() {
            return this.toolingVersion;
        }

        @Override
        public MavenConfiguration mavenConfiguration() {
            return this.mavenConfiguration;
        }

        @Override
        public Optional<URI> log4jConfiguration() {
            return Optional.ofNullable(this.log4jConfiguration);
        }

        @Override
        public Optional<ExecutorServiceConfiguration> executorServiceConfiguration() {
            return Optional.ofNullable(this.executorServiceConfiguration);
        }
    }
}

