/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.feature.Action;
import org.mule.tooling.client.api.feature.Feature;
import org.mule.tooling.client.api.metadata.MetadataKeysContainer;
import org.mule.tooling.client.api.metadata.MetadataKeysRequest;
import org.mule.tooling.client.api.metadata.MetadataResult;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.bootstrap.internal.wrapper.ActionWrapper;
import org.mule.tooling.client.internal.serialization.Serializer;

public class MetadataServiceWrapper
implements MetadataService {
    private Dispatcher dispatcher;
    private Serializer serializer;

    public MetadataServiceWrapper(Dispatcher dispatcher, Serializer serializer) {
        Objects.requireNonNull(dispatcher, "dispatcher cannot be null");
        Objects.requireNonNull(serializer, "serializer cannot be null");
        this.dispatcher = dispatcher;
        this.serializer = serializer;
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataKeysRequest metadataKeysRequest) throws ServiceUnavailableException {
        String result = (String)this.dispatcher.dispatchRemoteMethod("getMetadataKeys", metadataKeysRequest.getRequestTimeout(), (List<Class>)ImmutableList.of(MetadataKeysRequest.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)metadataKeysRequest)));
        return (MetadataResult)this.serializer.deserialize(result);
    }

    public Feature<Action<Location>> disposeMetadataCache() {
        if (this.dispatcher.isFeatureEnabled("disposeMetadataCache", new String[0])) {
            Object disposeMetadataCacheTarget = this.dispatcher.dispatchRemoteMethod("disposeMetadataCache");
            return Feature.enabled(new ActionWrapper<Location>(this.dispatcher.newReflectionInvoker(this.dispatcher.invokeGetOnFeature(disposeMetadataCacheTarget)), Location.class, this.serializer));
        }
        return Feature.disabled();
    }
}

