/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.bootstrap.api;

import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.ToolingRuntimeClientBuilderFactory;

import java.util.concurrent.ExecutorService;

/**
 * Responsible for boot strapping all the resources for a {@link ToolingRuntimeClient} of a given Mule Runtime version.
 * <p/>
 * Implements {@link Disposable}, clients should call {@link #dispose()}  in order to
 * release resources, caches and the isolated class loader created for the given Mule Runtime version.
 * <p/>
 * {@link ExecutorService#shutdown()} will be called during dispose phase if the {@link ExecutorService} was not provided by clients
 * to this {@link ToolingRuntimeClientBootstrap}, otherwise it is up to clients to shutdown the {@link ExecutorService}.
 *
 * @since 1.0
 */
public interface ToolingRuntimeClientBootstrap extends Disposable {

  /**
   * @return the Mule Runtime version for which this bootstrap has been created.
   */
  String getMuleVersion();

  /**
   * @return the Tooling Runtime Client version for which this bootstrap has been created.
   */
  String getToolingVersion();

  /**
   * @return {@link ToolingRuntimeClientBuilderFactory} to create a {@link ToolingRuntimeClient.Builder}.
   * Each {@link ToolingRuntimeClient} created with this factory should be disposed when no longer needed in order to
   * release resources.
   */
  ToolingRuntimeClientBuilderFactory getToolingRuntimeClientBuilderFactory();

}
