/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.bootstrap.internal;

import static java.lang.String.format;
import static org.mule.tooling.client.bootstrap.api.UpdatePolicy.UPDATE_POLICY_ALWAYS;
import static org.mule.tooling.client.bootstrap.api.UpdatePolicy.UPDATE_POLICY_DAILY;
import static org.mule.tooling.client.bootstrap.api.UpdatePolicy.UPDATE_POLICY_INTERVAL;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.bootstrap.api.UpdatePolicy;

/**
 * Utility class for {@link org.mule.tooling.client.bootstrap.api.UpdatePolicy}.
 */
public final class UpdatePolicyUtils {

  private UpdatePolicyUtils() {}

  /**
   * @return the update policy as minutes.
   */
  public static long toMinutes(UpdatePolicy updatePolicy) {
    if (UPDATE_POLICY_DAILY.equals(updatePolicy)) {
      return 1440;
    } else if (UPDATE_POLICY_ALWAYS.equals(updatePolicy)) {
      return 0;
    } else if (updatePolicy != null && updatePolicy.getUpdatePolicy().startsWith(UPDATE_POLICY_INTERVAL)) {
      return getMinutes(updatePolicy.getUpdatePolicy());
    } else {
      return Integer.MAX_VALUE;
    }
  }

  private static int getMinutes(String policy) {
    int minutes;
    try {
      String s = policy.substring(UPDATE_POLICY_INTERVAL.length() + 1);
      minutes = Integer.valueOf(s);
    } catch (RuntimeException e) {
      throw new ToolingException(format("Invalid update policy interval, pattern supported is: '%s', value was: '%s' where X is minutes",
                                        policy, UPDATE_POLICY_INTERVAL + ":X"));
    }
    return minutes;
  }


}
