/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.ToolingRuntimeClientBuilderFactory;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.bootstrap.internal.wrapper.BuilderWrapper;
import org.mule.tooling.client.internal.serialization.KryoClientSerializer;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.serialization.XStreamClientSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolingRuntimeClientBuilderFactoryWrapper
implements ToolingRuntimeClientBuilderFactory,
Disposable {
    public static final String ORG_MULE_TOOLING_CLIENT_INTERNAL_DEFAULT_TOOLING_RUNTIME_CLIENT_FACTORY = "org.mule.tooling.client.internal.DefaultToolingRuntimeClientFactory";
    private static Logger LOGGER = LoggerFactory.getLogger(ToolingRuntimeClientBuilderFactoryWrapper.class);
    private String muleVersion;
    private File workingDirectory;
    private ClassLoader toolingClassLoader;
    private Dispatcher dispatcher;
    private Serializer serializer;
    private MavenConfiguration mavenConfiguration;

    public ToolingRuntimeClientBuilderFactoryWrapper(String muleVersion, ClassLoader toolingClassLoader, ExecutorService executorService, MavenConfiguration mavenConfiguration, File workingDirectory) {
        Objects.requireNonNull(muleVersion, "muleVersion cannot be null");
        Objects.requireNonNull(toolingClassLoader, "toolingClassLoader cannot be null");
        Objects.requireNonNull(executorService, "executorService cannot be null");
        Objects.requireNonNull(mavenConfiguration, "mavenConfiguration cannot be null");
        this.muleVersion = muleVersion;
        this.workingDirectory = workingDirectory;
        this.toolingClassLoader = toolingClassLoader;
        Object toolingRuntimeClientFactory = this.withContextClassLoader(toolingClassLoader, () -> this.discoverToolingRuntimeClientFactory());
        this.serializer = this.discoverSerialization(toolingRuntimeClientFactory);
        this.dispatcher = new Dispatcher(toolingRuntimeClientFactory, toolingClassLoader, executorService);
        this.mavenConfiguration = mavenConfiguration;
        this.withContextClassLoader(toolingClassLoader, () -> this.initialise(toolingClassLoader, toolingRuntimeClientFactory));
    }

    private void withContextClassLoader(ClassLoader toolingClassLoader, Runnable runnable) {
        this.withContextClassLoader(toolingClassLoader, () -> {
            runnable.run();
            return null;
        });
    }

    private <T> T withContextClassLoader(ClassLoader toolingClassLoader, Callable<T> callable) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(toolingClassLoader);
            T t = callable.call();
            return t;
        }
        catch (ToolingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ToolingException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private void initialise(ClassLoader toolingClassLoader, Object toolingRuntimeClientFactory) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(toolingClassLoader);
            toolingRuntimeClientFactory.getClass().getMethod("initialise", new Class[0]).invoke(toolingRuntimeClientFactory, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException e) {
            throw new ToolingException("Error while initializing Tooling Runtime Client factory", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ToolingException("Error while initializing Tooling Runtime Client factory", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private Serializer discoverSerialization(Object toolingRuntimeClientFactory) {
        try {
            toolingRuntimeClientFactory.getClass().getMethod("setSerialization", String.class).invoke(toolingRuntimeClientFactory, KryoClientSerializer.NAME);
            LOGGER.info("Using Kryo serialization");
            return new KryoClientSerializer(this.getClass().getClassLoader(), toolingRuntimeClientFactory.getClass().getClassLoader());
        }
        catch (NoSuchMethodException e) {
            LOGGER.info("Using xStream serialization, as API supports Kryo but not the bootstrapped implementation");
            return new XStreamClientSerializer(toolingRuntimeClientFactory.getClass().getClassLoader());
        }
        catch (IllegalAccessException e) {
            throw new ToolingException("Error while discovering serialization", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ToolingException("Error while discovering serialization", (Throwable)e);
        }
    }

    private Object discoverToolingRuntimeClientFactory() {
        try {
            return this.toolingClassLoader.loadClass(ORG_MULE_TOOLING_CLIENT_INTERNAL_DEFAULT_TOOLING_RUNTIME_CLIENT_FACTORY).getConstructor(String.class, File.class).newInstance(this.muleVersion, this.workingDirectory);
        }
        catch (NoSuchMethodException e) {
            try {
                return this.toolingClassLoader.loadClass(ORG_MULE_TOOLING_CLIENT_INTERNAL_DEFAULT_TOOLING_RUNTIME_CLIENT_FACTORY).getConstructor(String.class).newInstance(this.muleVersion);
            }
            catch (NoSuchMethodException e1) {
                try {
                    ServiceLoader<?> serviceLoader = ServiceLoader.load(this.toolingClassLoader.loadClass(ToolingRuntimeClientBuilderFactory.class.getName()), this.toolingClassLoader);
                    if (!serviceLoader.iterator().hasNext()) {
                        throw new IllegalStateException("No service found for: '" + ToolingRuntimeClientBuilderFactory.class.getName() + "'");
                    }
                    return serviceLoader.iterator().next();
                }
                catch (ClassNotFoundException e2) {
                    throw new IllegalStateException(String.format("ClassLoader for Tooling was not correctly created as there is no implementation of %s", ToolingRuntimeClientBuilderFactory.class.getName()), e2);
                }
            }
            catch (Exception e3) {
                throw new IllegalStateException(String.format("Error while creating the implementation of %s", ToolingRuntimeClientBuilderFactory.class.getName()), e3);
            }
        }
        catch (Exception e4) {
            throw new IllegalStateException(String.format("Error while creating the implementation of %s", ToolingRuntimeClientBuilderFactory.class.getName()), e4);
        }
    }

    public void dispose() {
        this.dispatcher.dispatchRemoteMethod("dispose");
    }

    public ToolingRuntimeClient.Builder create() {
        Object builderTarget = this.dispatcher.dispatchRemoteMethod("create");
        BuilderWrapper builder = new BuilderWrapper(this.toolingClassLoader, this.dispatcher.newReflectionInvoker(builderTarget), this.serializer);
        builder.withMavenConfiguration(this.mavenConfiguration);
        return builder;
    }
}

