/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.bootstrap.internal;

import static java.util.Optional.ofNullable;
import org.mule.tooling.client.bootstrap.api.ToolingVersionResolver;

import java.util.Optional;

/**
 * Default implementation of {@link org.mule.tooling.client.bootstrap.api.ToolingVersionResolver.ToolingVersion}.
 */
public class DefaultToolingVersion implements ToolingVersionResolver.ToolingVersion {

  private String version;
  private String previousVersion;

  DefaultToolingVersion(String version, String previousVersion) {
    this.version = version;
    this.previousVersion = previousVersion;
  }

  @Override
  public String getVersion() {
    return version;
  }

  @Override
  public Optional<String> getPreviousVersion() {
    return ofNullable(previousVersion);
  }

}
