/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.module.embedded.internal.classloading.FilteringClassLoader;
import org.mule.runtime.module.embedded.internal.classloading.JdkOnlyClassLoaderFactory;
import org.mule.tooling.client.api.ToolingRuntimeClientBuilderFactory;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;
import org.mule.tooling.client.bootstrap.internal.classloader.ToolingClassLoader;
import org.mule.tooling.client.bootstrap.internal.wrapper.ToolingRuntimeClientBuilderFactoryWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.ToolingRuntimeClientBuilderFactoryWrapperBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultToolingRuntimeClientBootstrap
implements ToolingRuntimeClientBootstrap {
    public static final String CONFIG_DIR_NAME = "config";
    private static final String JAR = "jar";
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private static final String LOG4J2_DISABLE_JMX = "log4j2.disable.jmx";
    private static final String LOG4J2_LOGGER_CONTEXT_FACTORY = "log4j2.loggerContextFactory";
    private static final String LOG4J2_IS_WEBAPP = "log4j2.is.webapp";
    public static final String TOOLING_LOG4J_CONTEXT_FACTORY_CLASSNAME = "org.mule.tooling.client.internal.log4j.ToolingLog4jContextFactory";
    private static Logger LOGGER = LoggerFactory.getLogger(DefaultToolingRuntimeClientBootstrap.class);
    protected static final String ORG_MULE_TOOLING = "org.mule.tooling";
    protected static final String MULE_RUNTIME_TOOLING_CLIENT = "mule-runtime-tooling-client";
    private final ToolingRuntimeClientBootstrapConfiguration configuration;
    private final MavenClient mavenClient;
    private URLClassLoader toolingClassLoader;
    private ToolingRuntimeClientBuilderFactoryWrapper toolingRuntimeClientBuilderFactory;
    private File workingFolder;
    private ExecutorService executorService;
    private int threadNumber = 1;

    public DefaultToolingRuntimeClientBootstrap(ToolingRuntimeClientBootstrapConfiguration configuration) {
        this(configuration, MavenClientProvider.discoverProvider((ClassLoader)DefaultToolingRuntimeClientBootstrap.class.getClassLoader()), ToolingRuntimeClientBuilderFactoryWrapper.builder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultToolingRuntimeClientBootstrap(ToolingRuntimeClientBootstrapConfiguration configuration, MavenClientProvider mavenClientProvider, ToolingRuntimeClientBuilderFactoryWrapperBuilder toolingRuntimeClientBuilderFactoryWrapperBuilder) {
        Objects.requireNonNull(configuration, "configuration cannot be null");
        Objects.requireNonNull(mavenClientProvider, "mavenClientProvider cannot be null");
        this.configuration = configuration;
        LOGGER.info("Bootstrapping a Tooling Runtime Client version: {}", (Object)configuration.toolingVersion());
        String currentLog4jDisableJmx = System.setProperty(LOG4J2_DISABLE_JMX, "true");
        String currentLog4jIsWebApp = System.setProperty(LOG4J2_IS_WEBAPP, "true");
        String currentLog4jLoggerContextFactory = System.setProperty(LOG4J2_LOGGER_CONTEXT_FACTORY, TOOLING_LOG4J_CONTEXT_FACTORY_CLASSNAME);
        try {
            this.workingFolder = configuration.workingFolder();
            if (this.workingFolder == null) {
                this.workingFolder = Files.createTempDir();
            } else if (!this.workingFolder.exists() && !this.workingFolder.mkdirs()) {
                throw new RuntimeException(String.format("Could not create working directory: %s", this.workingFolder.getAbsolutePath()));
            }
            Optional<File> configDir = configuration.log4jConfiguration().map(log4JConfigurationFile -> {
                try (InputStream log4jConfigurationFileInputStream = log4JConfigurationFile.toURL().openStream();){
                    File confDir = new File(this.workingFolder, CONFIG_DIR_NAME);
                    confDir.deleteOnExit();
                    FileUtils.copyInputStreamToFile((InputStream)log4jConfigurationFileInputStream, (File)new File(confDir, "log4j2-test.xml"));
                    File file = confDir;
                    return file;
                }
                catch (Exception e) {
                    throw new ToolingException("Error while writing log4j configuration file", (Throwable)e);
                }
            });
            this.mavenClient = mavenClientProvider.createMavenClient(configuration.mavenConfiguration());
            this.toolingClassLoader = this.createClassLoader(configuration.toolingVersion(), configDir);
            int nThreads = Integer.max(AVAILABLE_PROCESSORS, 2);
            if (configuration.executorServiceConfiguration().isPresent()) {
                nThreads = configuration.executorServiceConfiguration().get().maxNumberOfThreads();
            }
            this.executorService = Executors.newFixedThreadPool(nThreads, runnable -> {
                Thread thread = new Thread(runnable, String.format("ToolingClient-%s-%s", this.threadNumber++, System.identityHashCode(this)));
                thread.setUncaughtExceptionHandler((t, e) -> LOGGER.error("Internal error", e));
                return thread;
            });
            this.toolingRuntimeClientBuilderFactory = toolingRuntimeClientBuilderFactoryWrapperBuilder.withToolingVersion(configuration.toolingVersion()).withToolingClassLoader(this.toolingClassLoader).withExecutorService(this.executorService).withMavenConfiguration(configuration.mavenConfiguration()).withWorkingDirectory(this.workingFolder).build();
        }
        finally {
            DefaultToolingRuntimeClientBootstrap.resetSystemProperty(LOG4J2_DISABLE_JMX, currentLog4jDisableJmx);
            DefaultToolingRuntimeClientBootstrap.resetSystemProperty(LOG4J2_IS_WEBAPP, currentLog4jIsWebApp);
            DefaultToolingRuntimeClientBootstrap.resetSystemProperty(LOG4J2_LOGGER_CONTEXT_FACTORY, currentLog4jLoggerContextFactory);
        }
    }

    private static void resetSystemProperty(String propertyName, String oldValue) {
        if (oldValue == null) {
            System.clearProperty(propertyName);
        } else {
            System.setProperty(propertyName, oldValue);
        }
    }

    private URLClassLoader createClassLoader(String toolingVersion, Optional<File> configDir) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating URL class loader for Tooling Runtime Client version: {}", (Object)toolingVersion);
            }
            List<File> dependencies = this.resolveDependency(ArtifactDescriptor.newBuilder().withGroupId(ORG_MULE_TOOLING).withArtifactId(MULE_RUNTIME_TOOLING_CLIENT).withVersion(toolingVersion).build());
            LinkedHashSet<File> classpath = new LinkedHashSet<File>();
            classpath.addAll(dependencies);
            BundleDependency bundleDependency = this.mavenClient.resolveBundleDescriptor(new BundleDescriptor.Builder().setGroupId(ORG_MULE_TOOLING).setArtifactId(MULE_RUNTIME_TOOLING_CLIENT).setVersion(toolingVersion).setType(JAR).build());
            LOGGER.info("Resolved version of Tooling implementation: {}", (Object)bundleDependency);
            Object[] urls = new URL[]{};
            urls = (URL[])ArrayUtils.addAll((Object[])urls, (Object[])new URL[]{this.getBundleUrl(bundleDependency)});
            urls = (URL[])ArrayUtils.addAll((Object[])urls, (Object[])classpath.stream().filter(file -> Files.getFileExtension((String)file.getAbsolutePath()).equals(JAR)).map(file -> DefaultToolingRuntimeClientBootstrap.toUrl(file)).toArray(URL[]::new));
            FilteringClassLoader jdkOnlyClassLoader = JdkOnlyClassLoaderFactory.create((ClassLoader)this.getClass().getClassLoader(), (Set)ImmutableSet.of((Object)"io.takari.filemanager"));
            if (configDir.isPresent()) {
                urls = (URL[])ArrayUtils.addAll((Object[])new URL[]{configDir.get().toURI().toURL()}, (Object[])urls);
            }
            ToolingClassLoader classLoader = new ToolingClassLoader(this.configuration.muleVersion(), this.configuration.toolingVersion(), System.identityHashCode(this), (URL[])urls, (ClassLoader)jdkOnlyClassLoader);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created Tooling Client class loader: {}", (Object)classLoader);
            }
            return classLoader;
        }
        catch (Exception e) {
            throw new ToolingException("Couldn't create the class loader for the Tooling Client", (Throwable)e);
        }
    }

    private URL getBundleUrl(BundleDependency bundleDependency) {
        try {
            return bundleDependency.getBundleUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new ToolingException("Error while getting bundleDependency URL", (Throwable)e);
        }
    }

    private List<File> resolveDependency(ArtifactDescriptor artifactDescriptor) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolving Tooling Runtime Client implementation libraries from: {}", (Object)artifactDescriptor);
        }
        List bundleDependencies = this.mavenClient.resolveBundleDescriptorDependencies(false, true, new BundleDescriptor.Builder().setGroupId(artifactDescriptor.getGroupId()).setArtifactId(artifactDescriptor.getArtifactId()).setVersion(artifactDescriptor.getVersion()).setType(artifactDescriptor.getExtension()).setClassifier(artifactDescriptor.getClassifier()).build());
        return bundleDependencies.stream().filter(bundleDependency -> bundleDependency.getBundleUri() != null).map(bundleDependency -> new File(bundleDependency.getBundleUri())).collect(Collectors.toList());
    }

    private static URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new ToolingException("Couldn't get URL for file: " + file, (Throwable)e);
        }
    }

    @Override
    public String getMuleVersion() {
        return this.configuration.muleVersion();
    }

    @Override
    public String getToolingVersion() {
        return this.configuration.toolingVersion();
    }

    @Override
    public ToolingRuntimeClientBuilderFactory getToolingRuntimeClientBuilderFactory() {
        if (this.toolingRuntimeClientBuilderFactory == null) {
            throw new IllegalStateException("Cannot be created a ToolingRuntimeClientBuilder once the bootstrap has been disposed");
        }
        return this.toolingRuntimeClientBuilderFactory;
    }

    public void dispose() {
        try {
            this.toolingRuntimeClientBuilderFactory.dispose();
        }
        finally {
            this.toolingRuntimeClientBuilderFactory = null;
        }
        this.executorService.shutdownNow();
        this.executorService = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing Tooling Client class loader: {}", (Object)this.toolingClassLoader);
        }
        this.closeClassLoader(this.toolingClassLoader);
        this.toolingClassLoader = null;
        if (this.workingFolder != null) {
            FileUtils.deleteQuietly((File)this.workingFolder);
        }
    }

    private void closeClassLoader(URLClassLoader classLoader) {
        block2: {
            try {
                classLoader.close();
            }
            catch (IOException e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Error while closing Tooling Client class loader", (Throwable)e);
            }
        }
    }
}

