/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.bootstrap.internal.wrapper;

import static com.google.common.collect.ImmutableList.of;
import static java.util.Objects.requireNonNull;
import org.mule.tooling.client.api.feature.Action;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.internal.serialization.Serializer;

/**
 * Client side implementation for {@link Action} that uses reflection and works as a bridge
 * between {@link ClassLoader classLoaders}.
 *
 * @since 1.0
 */

public class ActionWrapper<T> implements Action<T> {

  private Dispatcher dispatcher;
  private Class<T> parameterType;
  private Serializer serializer;

  public ActionWrapper(Dispatcher dispatcher, Class<T> parameterType, Serializer serializer) {
    requireNonNull(dispatcher, "dispatcher cannot be null");
    requireNonNull(parameterType, "parameterType cannot be null");
    requireNonNull(serializer, "serializer cannot be null");

    this.dispatcher = dispatcher;
    this.parameterType = parameterType;
    this.serializer = serializer;
  }

  @Override
  public void perform(T t) {
    dispatcher.dispatchRemoteMethod("perform", of(parameterType), of(serializer.serialize(t)));
  }
}
