/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageSerializer;
import org.mule.tooling.client.api.exception.ToolingException;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MetadataCacheStorageSerializerProxy implements MetadataCacheStorageSerializer {

  private Object proxyTarget;
  private Method serializeMethod;
  private Method deserializeMethod;

  public MetadataCacheStorageSerializerProxy(Object proxyTarget) {
    this.proxyTarget = proxyTarget;
    try {
      this.serializeMethod = proxyTarget.getClass().getDeclaredMethod("serialize", OutputStream.class, Object.class);
      this.deserializeMethod = proxyTarget.getClass().getDeclaredMethod("deserialize", InputStream.class);
    } catch (NoSuchMethodException e) {
      throw new ToolingException("Could not create cache serializer proxy", e);
    }
  }

  @Override
  public void serialize(OutputStream outputStream, Object object) {
    try {
      serializeMethod.invoke(proxyTarget, outputStream, object);
    } catch (IllegalAccessException | InvocationTargetException e) {
      throw new ToolingException("Could not execute serialize method via reflection", e);
    }
  }

  @Override
  public <T> T deserialize(InputStream serialized) {
    try {
      return (T) deserializeMethod.invoke(proxyTarget, serialized);
    } catch (IllegalAccessException | InvocationTargetException e) {
      throw new ToolingException("Could not execute deserialize method via reflection", e);
    }
  }

}
