/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.datasense.MetadataCacheFactory;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageFactory;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.feature.Action;
import org.mule.tooling.client.api.feature.Feature;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.bootstrap.internal.wrapper.ActionWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.DefaultMetadataCacheStorageMapWrapperFactory;
import org.mule.tooling.client.bootstrap.internal.wrapper.MetadataCacheStorageSerializerProxy;
import org.mule.tooling.client.bootstrap.internal.wrapper.ToolingRuntimeClientWrappper;
import org.mule.tooling.client.internal.serialization.Serializer;

public class BuilderWrapper
implements ToolingRuntimeClient.Builder {
    private final Dispatcher dispatcher;
    private ClassLoader toolingClassLoader;
    private Serializer serializer;

    public BuilderWrapper(ClassLoader toolingClassLoader, Dispatcher dispatcher, Serializer serializer) {
        Objects.requireNonNull(dispatcher, "dispatcher cannot be null");
        Objects.requireNonNull(toolingClassLoader, "toolingClassLoader cannot be null");
        Objects.requireNonNull(serializer, "serializer cannot be null");
        this.dispatcher = dispatcher;
        this.toolingClassLoader = toolingClassLoader;
        this.serializer = serializer;
    }

    public ToolingRuntimeClient.Builder withRemoteAgentConfiguration(AgentConfiguration agentConfiguration) {
        this.dispatcher.dispatchRemoteMethod("withRemoteAgentConfiguration", (List<Class>)ImmutableList.of(AgentConfiguration.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)agentConfiguration)));
        return this;
    }

    public ToolingRuntimeClient.Builder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
        this.dispatcher.dispatchRemoteMethod("withMavenConfiguration", (List<Class>)ImmutableList.of(MavenConfiguration.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)mavenConfiguration)));
        return this;
    }

    public Feature<Action<String>> withTargetRuntimeVersion() {
        String withTargetRuntimeVersionMethodName = "withTargetRuntimeVersion";
        if (this.dispatcher.isFeatureEnabled(withTargetRuntimeVersionMethodName, new String[0])) {
            Object withTargetRuntimeVersionTarget = this.dispatcher.dispatchRemoteMethod(withTargetRuntimeVersionMethodName);
            return Feature.enabled(targetMuleRuntimeVersion -> new ActionWrapper<String>(this.dispatcher.newReflectionInvoker(this.dispatcher.invokeGetOnFeature(withTargetRuntimeVersionTarget)), String.class, this.serializer).perform((String)targetMuleRuntimeVersion));
        }
        return Feature.disabled();
    }

    public ToolingRuntimeClient.Builder withMetadataCacheFactory(MetadataCacheFactory metadataCacheFactory) {
        try {
            Class<?> proxyMetadataCacheFactoryClazz = this.toolingClassLoader.loadClass("org.mule.tooling.client.internal.MetadataCacheFactoryProxy");
            String methodName = "withMetadataCacheFactory";
            Object proxyMetadataCacheFactory = proxyMetadataCacheFactoryClazz.getConstructor(Object.class).newInstance(metadataCacheFactory);
            Method method = this.dispatcher.findMethod(methodName);
            this.dispatcher.invoke(method, -1L, new Object[]{proxyMetadataCacheFactory});
            return this;
        }
        catch (Exception e) {
            throw new ToolingException("Couldn't create proxy for MetadataCacheFactory", (Throwable)e);
        }
    }

    public Feature<Action<MetadataCacheStorageFactory>> withMetadataCacheStorageFactory() {
        String withMetadataCacheStorageFactoryMethodName = "withMetadataCacheStorageFactory";
        if (this.dispatcher.isFeatureEnabled("withMetadataCacheStorageFactory", new String[0])) {
            return Feature.enabled(metadataCacheStorageFactory -> {
                try {
                    Class<?> defaultMetadataCacheStorageSerializerClass = this.toolingClassLoader.loadClass("org.mule.tooling.client.internal.metadata.DefaultMetadataCacheStorageSerializer");
                    Object cacheSerializer = defaultMetadataCacheStorageSerializerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    MetadataCacheStorageSerializerProxy metadataCacheStorageSerializer = new MetadataCacheStorageSerializerProxy(cacheSerializer);
                    DefaultMetadataCacheStorageMapWrapperFactory mapWrapperFactory = new DefaultMetadataCacheStorageMapWrapperFactory((MetadataCacheStorageFactory)metadataCacheStorageFactory, metadataCacheStorageSerializer);
                    Class<?> proxyMetadataCacheStorageMapWrapperFactoryClazz = this.toolingClassLoader.loadClass("org.mule.tooling.client.internal.metadata.MetadataCacheStorageMapWrapperFactoryProxy");
                    String methodName = "withMetadataCacheStorageMapWrapperFactory";
                    Object proxyMetadataCacheFactory = proxyMetadataCacheStorageMapWrapperFactoryClazz.getConstructor(Object.class).newInstance(mapWrapperFactory);
                    Method method = this.dispatcher.findMethod(methodName);
                    this.dispatcher.invoke(method, -1L, new Object[]{proxyMetadataCacheFactory});
                }
                catch (Exception e) {
                    throw new ToolingException("Couldn't create proxy for MetadataCacheFactory", (Throwable)e);
                }
            });
        }
        return Feature.disabled();
    }

    public ToolingRuntimeClient build() {
        Object clientTarget = this.dispatcher.dispatchRemoteMethod("build");
        return new ToolingRuntimeClientWrappper(this.dispatcher.newReflectionInvoker(clientTarget), this.serializer);
    }
}

