/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageSerializer;
import org.mule.tooling.client.api.exception.ToolingException;

public class MetadataCacheStorageSerializerProxy
implements MetadataCacheStorageSerializer {
    private Object proxyTarget;
    private Method serializeMethod;
    private Method deserializeMethod;

    public MetadataCacheStorageSerializerProxy(Object proxyTarget) {
        this.proxyTarget = proxyTarget;
        try {
            this.serializeMethod = proxyTarget.getClass().getDeclaredMethod("serialize", OutputStream.class, Object.class);
            this.deserializeMethod = proxyTarget.getClass().getDeclaredMethod("deserialize", InputStream.class);
        }
        catch (NoSuchMethodException e) {
            throw new ToolingException("Could not create cache serializer proxy", (Throwable)e);
        }
    }

    public void serialize(OutputStream outputStream, Object object) {
        try {
            this.serializeMethod.invoke(this.proxyTarget, outputStream, object);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ToolingException("Could not execute serialize method via reflection", (Throwable)e);
        }
    }

    public <T> T deserialize(InputStream serialized) {
        try {
            return (T)this.deserializeMethod.invoke(this.proxyTarget, serialized);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ToolingException("Could not execute deserialize method via reflection", (Throwable)e);
        }
    }
}

