/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorage;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageFactoryContext;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageSerializer;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageFactory;
import org.mule.tooling.client.internal.metadata.DefaultMetadataCacheStorageFactoryContext;
import org.mule.tooling.client.internal.metadata.MetadataCacheStorageMapWrapperFactory;

import java.net.URL;
import java.util.Map;

/**
 * {@link MetadataCacheStorageMapWrapperFactory} implementation that returns a {@link MetadataCacheStorageMapWrapper} that delegates to the
 * configured {@link MetadataCacheStorageFactory}.
 * </p>
 * Given that {@link MetadataCacheStorageMapWrapper} implements {@link Map} it can be used freely in any class loader (By referencing the interface)
 * without requiring refection.
 */
public class DefaultMetadataCacheStorageMapWrapperFactory implements MetadataCacheStorageMapWrapperFactory {

  private MetadataCacheStorageFactory metadataCacheStorageFactory;
  private MetadataCacheStorageSerializer valueSerializer;


  public DefaultMetadataCacheStorageMapWrapperFactory(MetadataCacheStorageFactory metadataCacheStorageFactory,
                                                      MetadataCacheStorageSerializer valueSerializer) {
    this.metadataCacheStorageFactory = metadataCacheStorageFactory;
    this.valueSerializer = valueSerializer;
  }

  @Override
  public Map<String, ?> create(String toolingArtifactId, URL artifactContentUrl, Map<String, String> properties) {
    MetadataCacheStorageFactoryContext metadataCacheStorageFactoryContext = new DefaultMetadataCacheStorageFactoryContext(
                                                                                                                          toolingArtifactId,
                                                                                                                          artifactContentUrl,
                                                                                                                          properties,
                                                                                                                          valueSerializer);
    MetadataCacheStorage metadataCacheStorage =
        metadataCacheStorageFactory.createMetadataCache(metadataCacheStorageFactoryContext);
    return new MetadataCacheStorageMapWrapper(metadataCacheStorage);
  }
}
