/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import org.mule.maven.client.api.model.MavenConfiguration;

import java.io.File;
import java.util.concurrent.ExecutorService;

/**
 * Builder for {@link ToolingRuntimeClientBuilderFactoryWrapper}.
 *
 * @since 1.2.0
 */
public interface ToolingRuntimeClientBuilderFactoryWrapperBuilder {

  ToolingRuntimeClientBuilderFactoryWrapperBuilder withToolingVersion(String toolingVersion);

  ToolingRuntimeClientBuilderFactoryWrapperBuilder withToolingClassLoader(ClassLoader toolingClassLoader);

  ToolingRuntimeClientBuilderFactoryWrapperBuilder withExecutorService(ExecutorService executorService);

  ToolingRuntimeClientBuilderFactoryWrapperBuilder withMavenConfiguration(MavenConfiguration mavenConfiguration);

  ToolingRuntimeClientBuilderFactoryWrapperBuilder withWorkingDirectory(File workingDirectory);

  ToolingRuntimeClientBuilderFactoryWrapper build();

}
