/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import org.mule.tooling.client.api.cache.CacheStorage;
import org.mule.tooling.client.api.cache.CacheStorageFactory;
import org.mule.tooling.client.api.cache.CacheStorageFactoryContext;
import org.mule.tooling.client.api.cache.CacheStorageSerializer;
import org.mule.tooling.client.internal.cache.CacheStorageMapWrapperFactory;
import org.mule.tooling.client.internal.cache.DefaultCacheStorageFactoryContext;
import org.mule.tooling.client.internal.metadata.MetadataCacheStorageMapWrapperFactory;

import java.net.URL;
import java.util.Map;

/**
 * {@link CacheStorageMapWrapperFactory} implementation that returns a {@link CacheStorageMapWrapper} that delegates to the
 * configured {@link org.mule.tooling.client.api.cache.CacheStorageFactory}.
 * </p>
 * Given that {@link CacheStorageMapWrapper} implements {@link Map} it can be used freely in any class loader (By referencing the interface)
 * without requiring refection.
 */
public class DefaultCacheStorageMapWrapperFactory
    implements CacheStorageMapWrapperFactory, MetadataCacheStorageMapWrapperFactory {

  private CacheStorageFactory cacheStorageFactory;
  private CacheStorageSerializer storageSerializer;


  public DefaultCacheStorageMapWrapperFactory(CacheStorageFactory cacheStorageFactory,
                                              CacheStorageSerializer storageSerializer) {
    this.cacheStorageFactory = cacheStorageFactory;
    this.storageSerializer = storageSerializer;
  }

  @Override
  public Map<String, ?> create(String toolingArtifactId, URL artifactContentUrl, Map<String, String> properties) {
    CacheStorageFactoryContext cacheStorageFactoryContext = new DefaultCacheStorageFactoryContext(toolingArtifactId,
                                                                                                  artifactContentUrl,
                                                                                                  properties,
                                                                                                  storageSerializer);
    CacheStorage cacheStorage = cacheStorageFactory.createCacheStorage(cacheStorageFactoryContext);
    return new CacheStorageMapWrapper(cacheStorage);
  }
}
