/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.bootstrap.api;

import static org.mule.maven.client.api.MavenClientProvider.discoverProvider;

import org.mule.tooling.client.bootstrap.internal.LibFolderToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.internal.MavenToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.internal.MavenToolingVersionResolver;

/**
 * Factory for {@link ToolingRuntimeClientBootstrap} instances.
 *
 * @since 1.0
 */
public class ToolingRuntimeClientBootstrapFactory {

  /**
   * Creates an instance of {@link ToolingRuntimeClientBootstrap} for the given
   * {@link ToolingRuntimeClientBootstrapConfiguration}.
   *
   * @param configuration {@link ToolingRuntimeClientBootstrapConfiguration} that defines the settings for the bootstrap instance.
   * @return a {@link ToolingRuntimeClientBootstrap}
   */
  public static final ToolingRuntimeClientBootstrap newToolingRuntimeClientBootstrap(ToolingRuntimeClientBootstrapConfiguration configuration) {
    if (configuration.toolingLibsFolder() != null) {
      return new LibFolderToolingRuntimeClientBootstrap(configuration);
    } else {
      return new MavenToolingRuntimeClientBootstrap(configuration);
    }
  }

  /**
   * Creates an instance of {@link ToolingVersionResolver}.
   *
   * @param configuration {@link ToolingVersionResolverConfiguration} that defines configuration for resolving versions.
   * @return a {@link ToolingVersionResolver}
   */
  public static final ToolingVersionResolver newToolingVersionResolver(ToolingVersionResolverConfiguration configuration) {
    return new MavenToolingVersionResolver(configuration,
                                           discoverProvider(MavenToolingRuntimeClientBootstrap.class.getClassLoader())
                                               .createMavenClient(configuration.mavenConfiguration()));
  }
}
