/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import static java.util.Collections.emptyList;
import static java.util.Objects.requireNonNull;
import org.mule.tooling.client.api.component.location.ArtifactComponentLocations;
import org.mule.tooling.client.api.component.location.ComponentLocationService;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.internal.serialization.Serializer;

public class ComponentLocationServiceWrapper implements ComponentLocationService {

  private Dispatcher dispatcher;
  private Serializer serializer;

  public ComponentLocationServiceWrapper(Dispatcher dispatcher, Serializer serializer) {
    requireNonNull(dispatcher, "dispatcher cannot be null");
    requireNonNull(serializer, "serializer cannot be null");

    this.dispatcher = dispatcher;
    this.serializer = serializer;
  }

  @Override
  public ArtifactComponentLocations getComponentLocations() {
    String result = (String) dispatcher.dispatchRemoteMethod("getComponentLocations",
                                                             emptyList(),
                                                             emptyList());
    return serializer.deserialize(result);
  }
}
