/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.bootstrap.internal.features;

import org.junit.Before;
import org.junit.Test;
import org.mule.tooling.client.api.feature.Feature;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;

import java.util.concurrent.ExecutorService;

import static java.util.concurrent.Executors.newFixedThreadPool;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.CoreMatchers.is;
import static org.mule.tooling.client.api.feature.Feature.enabled;


public class FeatureDiscoveryTestCase {

  private static final String TEST_MESSAGE = "Messi";

  private Dispatcher dispatcher;
  ExecutorService executorService = newFixedThreadPool(1, runnable -> new Thread(runnable));

  @Before
  public void setup() {
    dispatcher = new Dispatcher(new MyServiceImpl(), this.getClass().getClassLoader(), executorService);
  }

  @Test
  public void testEnabledFeature() {
    assertThat(dispatcher.isFeatureEnabled("service", new String[] {}), is(true));
  }

  @Test
  public void testInvokeEnabledFeature() {
    assertThat(dispatcher.dispatchRemoteMethod("service"), is(enabled(TEST_MESSAGE)));
  }

  @Test
  public void testDisabledFeature() {
    assertThat(dispatcher.isFeatureEnabled("unkownService", new String[] {}), is(false));
  }

  private class MyServiceImpl {

    public boolean isFeatureEnabled(String methodName, String[] classes) {
      return methodName.equals("service");
    }

    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
      if (methodName.equals("service")) {
        return service();
      } else {
        throw new IllegalArgumentException();
      }
    }

    public Feature<String> service() {
      return enabled(TEST_MESSAGE);
    }
  }
}
