/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.bootstrap.api;

/**
 * Defines the update policy for fetching remote versions.
 *
 * @since 1.1
 */
public final class UpdatePolicy {

  /**
   * Never update locally cached data.
   */
  public static final String UPDATE_POLICY_NEVER = "never";

  /**
   * Always update locally cached data.
   */
  public static final String UPDATE_POLICY_ALWAYS = "always";

  /**
   * Update locally cached data once a day.
   */
  public static final String UPDATE_POLICY_DAILY = "daily";

  /**
   * Update locally cached data every X minutes as given by "interval:X".
   */
  public static final String UPDATE_POLICY_INTERVAL = "interval";

  private final String updatePolicy;

  /**
   * Creates a new policy with update policy.
   */
  public UpdatePolicy(String updatePolicy) {
    this.updatePolicy = updatePolicy;
  }

  public String getUpdatePolicy() {
    return updatePolicy;
  }

}
