/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.module.embedded.internal.classloading.FilteringClassLoader;
import org.mule.runtime.module.embedded.internal.classloading.JdkOnlyClassLoaderFactory;
import org.mule.tooling.client.api.ToolingRuntimeClientBuilderFactory;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;
import org.mule.tooling.client.bootstrap.internal.classloader.ToolingClassLoader;
import org.mule.tooling.client.bootstrap.internal.wrapper.ToolingRuntimeClientBuilderFactoryWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.ToolingRuntimeClientBuilderFactoryWrapperBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibFolderToolingRuntimeClientBootstrap
implements ToolingRuntimeClientBootstrap {
    public static final String CONFIG_DIR_NAME = "config";
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private static final String LOG4J2_DISABLE_JMX = "log4j2.disable.jmx";
    private static final String LOG4J2_LOGGER_CONTEXT_FACTORY = "log4j2.loggerContextFactory";
    private static final String LOG4J2_IS_WEBAPP = "log4j2.is.webapp";
    public static final String TOOLING_LOG4J_CONTEXT_FACTORY_CLASSNAME = "org.mule.tooling.client.internal.log4j.ToolingLog4jContextFactory";
    private static Logger LOGGER = LoggerFactory.getLogger(LibFolderToolingRuntimeClientBootstrap.class);
    private final ToolingRuntimeClientBootstrapConfiguration configuration;
    private URLClassLoader toolingClassLoader;
    private ToolingRuntimeClientBuilderFactoryWrapper toolingRuntimeClientBuilderFactory;
    private File workingFolder;
    private ExecutorService executorService;
    private int threadNumber = 1;

    public LibFolderToolingRuntimeClientBootstrap(ToolingRuntimeClientBootstrapConfiguration configuration) {
        this(configuration, ToolingRuntimeClientBuilderFactoryWrapper.builder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LibFolderToolingRuntimeClientBootstrap(ToolingRuntimeClientBootstrapConfiguration configuration, ToolingRuntimeClientBuilderFactoryWrapperBuilder toolingRuntimeClientBuilderFactoryWrapperBuilder) {
        Objects.requireNonNull(configuration, "configuration cannot be null");
        this.configuration = configuration;
        LOGGER.info("Bootstrapping a Tooling Runtime Client version: {}", (Object)configuration.toolingVersion());
        String currentLog4jDisableJmx = System.setProperty(LOG4J2_DISABLE_JMX, "true");
        String currentLog4jIsWebApp = System.setProperty(LOG4J2_IS_WEBAPP, "true");
        String currentLog4jLoggerContextFactory = System.setProperty(LOG4J2_LOGGER_CONTEXT_FACTORY, TOOLING_LOG4J_CONTEXT_FACTORY_CLASSNAME);
        try {
            this.workingFolder = configuration.workingFolder();
            if (this.workingFolder == null) {
                this.workingFolder = Files.createTempDir();
            } else if (!this.workingFolder.exists() && !this.workingFolder.mkdirs()) {
                throw new RuntimeException(String.format("Could not create working directory: %s", this.workingFolder.getAbsolutePath()));
            }
            Optional<File> configDir = configuration.log4jConfiguration().map(log4JConfigurationFile -> {
                try (InputStream log4jConfigurationFileInputStream = log4JConfigurationFile.toURL().openStream();){
                    File confDir = new File(this.workingFolder, CONFIG_DIR_NAME);
                    confDir.deleteOnExit();
                    FileUtils.copyInputStreamToFile((InputStream)log4jConfigurationFileInputStream, (File)new File(confDir, "log4j2-test.xml"));
                    File file = confDir;
                    return file;
                }
                catch (Exception e) {
                    throw new ToolingException("Error while writing log4j configuration file", (Throwable)e);
                }
            });
            this.toolingClassLoader = this.createClassLoader(configuration.toolingLibsFolder(), configuration.toolingVersion(), configDir);
            int nThreads = Integer.max(AVAILABLE_PROCESSORS, 2);
            if (configuration.executorServiceConfiguration().isPresent()) {
                nThreads = configuration.executorServiceConfiguration().get().maxNumberOfThreads();
            }
            this.executorService = Executors.newFixedThreadPool(nThreads, runnable -> {
                Thread thread = new Thread(runnable, String.format("ToolingClient-%s-%s", this.threadNumber++, System.identityHashCode(this)));
                thread.setUncaughtExceptionHandler((t, e) -> LOGGER.error("Internal error", e));
                return thread;
            });
            this.toolingRuntimeClientBuilderFactory = toolingRuntimeClientBuilderFactoryWrapperBuilder.withToolingVersion(configuration.toolingVersion()).withToolingClassLoader(this.toolingClassLoader).withExecutorService(this.executorService).withMavenConfiguration(configuration.mavenConfiguration()).withWorkingDirectory(this.workingFolder).build();
        }
        finally {
            LibFolderToolingRuntimeClientBootstrap.resetSystemProperty(LOG4J2_DISABLE_JMX, currentLog4jDisableJmx);
            LibFolderToolingRuntimeClientBootstrap.resetSystemProperty(LOG4J2_IS_WEBAPP, currentLog4jIsWebApp);
            LibFolderToolingRuntimeClientBootstrap.resetSystemProperty(LOG4J2_LOGGER_CONTEXT_FACTORY, currentLog4jLoggerContextFactory);
        }
    }

    private static void resetSystemProperty(String propertyName, String oldValue) {
        if (oldValue == null) {
            System.clearProperty(propertyName);
        } else {
            System.setProperty(propertyName, oldValue);
        }
    }

    private URLClassLoader createClassLoader(File toolingLibsFolder, String toolingVersion, Optional<File> configDir) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating URL class loader for Tooling Runtime Client version: {}", (Object)toolingVersion);
            }
            SuffixFileFilter filter = new SuffixFileFilter(".jar", IOCase.SYSTEM);
            Object[] urls = (URL[])Arrays.stream(toolingLibsFolder.listFiles((FileFilter)filter)).map(jarFile -> {
                try {
                    return jarFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new ToolingException("Couldn't create the class loader for the Tooling Client", (Throwable)e);
                }
            }).toArray(URL[]::new);
            FilteringClassLoader jdkOnlyClassLoader = JdkOnlyClassLoaderFactory.create((ClassLoader)this.getClass().getClassLoader(), (Set)ImmutableSet.of((Object)"io.takari.filemanager"));
            if (configDir.isPresent()) {
                urls = (URL[])ArrayUtils.addAll((Object[])new URL[]{configDir.get().toURI().toURL()}, (Object[])urls);
            }
            ToolingClassLoader classLoader = new ToolingClassLoader(this.configuration.muleVersion(), this.configuration.toolingVersion(), System.identityHashCode(this), (URL[])urls, (ClassLoader)jdkOnlyClassLoader);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created Tooling Client class loader: {}", (Object)classLoader);
            }
            return classLoader;
        }
        catch (Exception e) {
            throw new ToolingException("Couldn't create the class loader for the Tooling Client", (Throwable)e);
        }
    }

    @Override
    public ToolingRuntimeClientBuilderFactory getToolingRuntimeClientBuilderFactory() {
        if (this.toolingRuntimeClientBuilderFactory == null) {
            throw new IllegalStateException("Cannot be created a ToolingRuntimeClientBuilder once the bootstrap has been disposed");
        }
        return this.toolingRuntimeClientBuilderFactory;
    }

    @Override
    public String getMuleVersion() {
        return this.configuration.muleVersion();
    }

    @Override
    public String getToolingVersion() {
        return this.configuration.toolingVersion();
    }

    public void dispose() {
        try {
            this.toolingRuntimeClientBuilderFactory.dispose();
        }
        finally {
            this.toolingRuntimeClientBuilderFactory = null;
        }
        this.executorService.shutdownNow();
        this.executorService = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing Tooling Client class loader: {}", (Object)this.toolingClassLoader);
        }
        this.closeClassLoader(this.toolingClassLoader);
        this.toolingClassLoader = null;
        if (this.workingFolder != null) {
            FileUtils.deleteQuietly((File)this.workingFolder);
        }
    }

    private void closeClassLoader(URLClassLoader classLoader) {
        block2: {
            try {
                classLoader.close();
            }
            catch (IOException e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Error while closing Tooling Client class loader", (Throwable)e);
            }
        }
    }
}

