/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.bootstrap.api;

import java.util.Map;

/**
 * Dynamic configuration for {@link ToolingVersionResolverConfiguration} that extends the state of the configuration with the
 * dynamic mappings resolved through Maven on remote repositories.
 *
 * @since 1.0
 */
public interface DynamicToolingVersionResolverConfiguration extends ToolingVersionResolverConfiguration {

  /**
   * @return {@link Map<String, String>} with the resolved dynamic mappings from Maven that will be populated whenever
   *         {@link ToolingVersionResolver} uses Maven to resolve the Tooling Runtime Client version for a Mule Runtime that is
   *         not defined in {@link ToolingVersionResolverConfiguration#mappings()}.
   *         <p/>
   *         The {@link Map<String,String>} has as key the Mule Runtime version as Maven range {@code [4.0.0,4.1.0)} and value is
   *         the resolved Tooling Runtime Client version.
   */
  Map<String, String> dynamicMappings();

}
