/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import org.mule.tooling.client.api.cache.CacheStorageSerializer;
import org.mule.tooling.client.api.declaration.session.DeclarationSessionCacheService;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.internal.serialization.Serializer;

import com.google.common.collect.ImmutableList;

public class DeclarationSessionCacheServiceWrapper implements DeclarationSessionCacheService {

  private final Dispatcher dispatcher;
  private final Serializer internalSerializer;
  private CacheStorageSerializer remoteSerializer;

  public DeclarationSessionCacheServiceWrapper(Dispatcher dispatcher, Serializer internalSerializer) {
    this.dispatcher = dispatcher;
    this.internalSerializer = internalSerializer;
  }

  @Override
  public CacheStorageSerializer getSerializer() {
    // Store the serializer to avoid looking for methods by reflection every time.
    if (remoteSerializer == null) {
      this.remoteSerializer =
          new CacheStorageSerializerProxy(dispatcher.dispatchRemoteMethod("getSerializer"));
    }
    return remoteSerializer;
  }

  @Override
  public void invalidateDependencies(String globalElementName) {
    dispatcher.dispatchRemoteMethod("invalidateDependencies",
                                    ImmutableList.of(String.class),
                                    ImmutableList.of(internalSerializer.serialize(globalElementName)));
  }
}
