/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import static java.util.Objects.requireNonNull;

import org.mule.tooling.client.api.sampledata.ComponentSampleDataResult;
import org.mule.tooling.client.api.sampledata.SampleDataService;
import org.mule.tooling.client.api.sampledata.request.SampleDataRequest;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.internal.serialization.Serializer;

import com.google.common.collect.ImmutableList;

/**
 * Client side implementation for {@link SampleDataService} that uses reflection and works as a bridge between {@link ClassLoader
 * classLoaders}.
 *
 * @since 1.4
 */
public class SampleDataServiceWrapper implements SampleDataService {

  private final Dispatcher dispatcher;
  private final Serializer serializer;

  public SampleDataServiceWrapper(Dispatcher dispatcher, Serializer serializer) {
    requireNonNull(dispatcher, "dispatcher cannot be null");
    requireNonNull(serializer, "serializer cannot be null");

    this.dispatcher = dispatcher;
    this.serializer = serializer;
  }

  @Override
  public ComponentSampleDataResult getSampleData(SampleDataRequest sampleDataRequest) {
    String result = (String) dispatcher.dispatchRemoteMethod("getSampleData",
                                                             sampleDataRequest.getRequestTimeout(),
                                                             ImmutableList.of(SampleDataRequest.class),
                                                             ImmutableList.of(serializer.serialize(sampleDataRequest)));
    return serializer.deserialize(result);
  }

}
