/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.mule.tooling.client.api.exception.NoSuchApplicationException;
import org.mule.tooling.client.api.message.history.MessageHistory;
import org.mule.tooling.client.api.message.history.MessageHistoryService;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.internal.serialization.Serializer;

public class MessageHistoryServiceWrapper
implements MessageHistoryService {
    private Dispatcher dispatcher;
    private Serializer serializer;

    public MessageHistoryServiceWrapper(Dispatcher dispatcher, Serializer serializer) {
        Objects.requireNonNull(dispatcher, "dispatcher cannot be null");
        Objects.requireNonNull(serializer, "serializer cannot be null");
        this.dispatcher = dispatcher;
        this.serializer = serializer;
    }

    public void enable(String applicationName) throws NoSuchApplicationException {
        this.dispatcher.dispatchRemoteMethod("enable", (List<Class>)ImmutableList.of(String.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)applicationName)));
    }

    public MessageHistory consume(String applicationName, int chunkSize) {
        String result = (String)this.dispatcher.dispatchRemoteMethod("consume", (List<Class>)ImmutableList.of(String.class, Integer.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)applicationName), (Object)this.serializer.serialize((Object)chunkSize)));
        return (MessageHistory)this.serializer.deserialize(result);
    }

    public void disable(String applicationName) {
        this.dispatcher.dispatchRemoteMethod("disable", (List<Class>)ImmutableList.of(String.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)applicationName)));
    }
}

