/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.bootstrap.internal;

import static org.mule.tooling.client.internal.util.Preconditions.checkState;
import org.mule.tooling.client.bootstrap.api.ExecutorServiceConfiguration;

/**
 * Default implementation of
 * {@link org.mule.tooling.client.bootstrap.api.ExecutorServiceConfiguration.ExecutorServiceConfigurationBuilder}.
 */
public class DefaultExecutorServiceConfigurationBuilder implements
    ExecutorServiceConfiguration.ExecutorServiceConfigurationBuilder {

  private int maxNumberOfThreads;

  @Override
  public ExecutorServiceConfiguration.ExecutorServiceConfigurationBuilder maxNumberOfThreads(int maxNumberOfThreads) {
    checkState(maxNumberOfThreads > 0, "maxNumberOfThreads has to be greater than 0");
    this.maxNumberOfThreads = maxNumberOfThreads;
    return this;
  }

  @Override
  public ExecutorServiceConfiguration build() {
    return new DefaultExecutorServiceConfigurationBuilder.DefaultExecutorServiceConfiguration(maxNumberOfThreads);
  }

  private static class DefaultExecutorServiceConfiguration implements ExecutorServiceConfiguration {

    private int maxNumberOfThreads;

    DefaultExecutorServiceConfiguration(int maxNumberOfThreads) {
      this.maxNumberOfThreads = maxNumberOfThreads;
    }

    @Override
    public int maxNumberOfThreads() {
      return maxNumberOfThreads;
    }
  }
}
