/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.reflection;

import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.mule.tooling.client.api.exception.ToolingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class Dispatcher {
    private static final String DISPATCH_METHOD_NAME = "invokeMethod";
    private static final String IS_FEATURE_ENABLED_NAME = "isFeatureEnabled";
    private static final List<String> DESERIALIZED_PACKAGES = Arrays.asList("org.mule.tooling", "com.thoughtworks.xstream", "org.mule.maven");
    private static Logger LOGGER = LoggerFactory.getLogger(Dispatcher.class);
    private Object target;
    private Method dispatchMethod;
    private ClassLoader classLoader;
    private ExecutorService executorService;
    private Method clearAllThreadLocalsMethod;

    public Dispatcher(Object target, ClassLoader classLoader, ExecutorService executorService) {
        Objects.requireNonNull(target, "target cannot be null");
        Objects.requireNonNull(classLoader, "classLoader cannot be null");
        Objects.requireNonNull(executorService, "executorService cannot be null");
        this.target = target;
        this.dispatchMethod = this.findMethod(DISPATCH_METHOD_NAME);
        this.dispatchMethod.setAccessible(true);
        this.classLoader = classLoader;
        this.executorService = executorService;
        try {
            this.clearAllThreadLocalsMethod = classLoader.loadClass("org.apache.xmlbeans.ThreadLocalUtil").getMethod("clearAllThreadLocals", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    public Dispatcher newReflectionInvoker(Object target) {
        return new Dispatcher(target, this.classLoader, this.executorService);
    }

    public Object invoke(Method method, long timeout, Object[] args) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Dispatching method '%s' on '%s' (timeout=%ss)", method, this.target.getClass(), timeout));
        }
        Map copyOfContextMap = (Map)ObjectUtils.defaultIfNull((Object)MDC.getCopyOfContextMap(), Collections.emptyMap());
        Future<Object> future = this.executorService.submit(new ToolingCallable(method, args, copyOfContextMap));
        try {
            if (timeout != -1L) {
                return future.get(timeout, TimeUnit.MILLISECONDS);
            }
            return future.get();
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new org.mule.tooling.client.api.exception.TimeoutException(String.format("Couldn't resolve the operation in the the expected time frame (%sms)", timeout), (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable deserializedException;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("Error response from method %s dispatched on Tooling Client was: %s", method, e.getCause().getMessage()), (Throwable)e);
            }
            if (!Dispatcher.isDeserializedException(e.getCause().getClass().getPackage().getName())) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
            try {
                deserializedException = (Throwable)Dispatcher.deserialize(new ByteArrayInputStream(SerializationUtils.serialize((Serializable)e.getCause())), this.getClass().getClassLoader());
            }
            catch (Exception serializationException) {
                LOGGER.error("Error while trying to deserialize exception", (Throwable)serializationException);
                throw new ToolingException("Internal error, an incompatible exception was thrown and cannot be deserialized with this version of the API", e.getCause());
            }
            throw Throwables.propagate((Throwable)deserializedException);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isDeserializedException(String packageName) {
        return DESERIALIZED_PACKAGES.stream().anyMatch(deserializedPackage -> packageName.startsWith((String)deserializedPackage));
    }

    public Object dispatchRemoteMethod(String targetMethodName) {
        return this.dispatchRemoteMethod(targetMethodName, -1L, null, null);
    }

    public Object dispatchRemoteMethod(String targetMethodName, List<Class> classes, List<String> args) {
        return this.dispatchRemoteMethod(targetMethodName, -1L, classes, args);
    }

    public Object dispatchRemoteMethod(String targetMethodName, long timeout, List<Class> classes, List<String> args) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add(targetMethodName);
        this.addArrayArgument(classes, clazz -> clazz.getName(), arguments);
        this.addArrayArgument(args, arg -> arg, arguments);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Dispatching method '%s' on '%s' (timeout=%ss)", targetMethodName, this.target.getClass(), timeout));
        }
        return this.invoke(this.dispatchMethod, timeout, arguments.toArray());
    }

    private <T> void addArrayArgument(List<T> args, Function<T, String> function, List<Object> target) {
        if (args != null && args.size() > 0) {
            target.add(args.stream().map(argument -> (String)function.apply(argument)).toArray(String[]::new));
        } else {
            target.add(new String[0]);
        }
    }

    public Method findMethod(String methodName) {
        Method[] methods;
        ArrayList<Method> methodsFound = new ArrayList<Method>();
        for (Method method : methods = this.target.getClass().getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            methodsFound.add(method);
        }
        if (methodsFound.isEmpty()) {
            throw new IllegalStateException(new NoSuchMethodException(String.format("Method '%s' not found on %s", methodName, this.target.getClass())));
        }
        if (methodsFound.size() > 1) {
            throw new IllegalStateException(String.format("%s has more than one %s method", this.target.getClass(), methodName));
        }
        return (Method)methodsFound.get(0);
    }

    public static Object deserialize(InputStream inputStream, ClassLoader cl) {
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        if (cl == null) {
            throw new IllegalArgumentException("The ClassLoader must not be null");
        }
        ClassLoaderObjectInputStream in = null;
        try {
            in = new ClassLoaderObjectInputStream(cl, inputStream);
            Object object = in.readObject();
            return object;
        }
        catch (ClassNotFoundException ex) {
            throw new SerializationException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
        catch (Exception ex) {
            throw new SerializationException((Throwable)ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isFeatureEnabled(String methodName, String[] classes) {
        Method isFeatureEnabledMethod = this.findMethod(IS_FEATURE_ENABLED_NAME);
        isFeatureEnabledMethod.setAccessible(true);
        return (Boolean)this.invoke(isFeatureEnabledMethod, -1L, new Object[]{methodName, classes});
    }

    public Object invokeGetOnFeature(Object featureTarget) {
        try {
            Method getMethod = featureTarget.getClass().getMethod("get", new Class[0]);
            return getMethod.invoke(featureTarget, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class ToolingCallable
    implements Callable<Object> {
        private final Method method;
        private final Object[] args;
        private final Map<String, String> copyOfContextMap;

        public ToolingCallable(Method method, Object[] args, Map<String, String> copyOfContextMap) {
            this.method = method;
            this.args = args;
            this.copyOfContextMap = copyOfContextMap;
        }

        @Override
        public Object call() throws Exception {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Dispatcher.this.classLoader.loadClass(MDC.class.getName()).getMethod("setContextMap", Map.class).invoke(null, this.copyOfContextMap);
                Thread.currentThread().setContextClassLoader(Dispatcher.this.classLoader);
                Object object = this.method.invoke(Dispatcher.this.target, this.args);
                return object;
            }
            catch (InvocationTargetException e) {
                Throwable cause;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("Error while calling method '%s' on '%s', error: %s", this.method, Dispatcher.this.target.getClass(), e.getCause().getMessage()));
                }
                if ((cause = e.getCause()) instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new IllegalStateException(cause);
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
                MDC.clear();
                if (Dispatcher.this.clearAllThreadLocalsMethod != null) {
                    Dispatcher.this.clearAllThreadLocalsMethod.invoke(null, new Object[0]);
                }
            }
        }
    }
}

