/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.app.declaration.api.TopLevelParameterDeclaration;
import org.mule.tooling.client.api.cache.CacheStorage;
import org.mule.tooling.client.api.connectivity.ConnectionValidationResult;
import org.mule.tooling.client.api.declaration.session.DeclarationSession;
import org.mule.tooling.client.api.declaration.session.DeclarationSessionCacheService;
import org.mule.tooling.client.api.descriptors.dependency.Dependency;
import org.mule.tooling.client.api.metadata.ComponentMetadataTypesDescriptor;
import org.mule.tooling.client.api.metadata.MetadataResult;
import org.mule.tooling.client.api.sampledata.ComponentSampleDataResult;
import org.mule.tooling.client.api.value.resolver.ValueResolverResult;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.bootstrap.internal.wrapper.CacheStorageMapWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.DeclarationSessionCacheServiceWrapper;
import org.mule.tooling.client.internal.serialization.Serializer;

public class DeclarationSessionWrapper
implements DeclarationSession {
    private Dispatcher dispatcher;
    private Serializer serializer;

    public DeclarationSessionWrapper(Dispatcher dispatcher, Serializer serializer) {
        Objects.requireNonNull(dispatcher, "dispatcher cannot be null");
        Objects.requireNonNull(serializer, "serializer cannot be null");
        Objects.requireNonNull(serializer, "cache service cannot be null");
        this.dispatcher = dispatcher;
        this.serializer = serializer;
    }

    public ValueResolverResult getValues(ParameterizedElementDeclaration elementDeclaration, String parameterName, boolean ignoreCache) {
        String result = (String)this.dispatcher.dispatchRemoteMethod("getValues", (List<Class>)ImmutableList.of(ParameterizedElementDeclaration.class, String.class, Boolean.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)elementDeclaration), (Object)this.serializer.serialize((Object)parameterName), (Object)this.serializer.serialize((Object)ignoreCache)));
        return (ValueResolverResult)this.serializer.deserialize(result);
    }

    public ValueResolverResult getFieldValues(ParameterizedElementDeclaration elementDeclaration, String parameterName, String targetPath, boolean ignoreCache) {
        String result = (String)this.dispatcher.dispatchRemoteMethod("getFieldValues", (List<Class>)ImmutableList.of(ParameterizedElementDeclaration.class, String.class, String.class, Boolean.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)elementDeclaration), (Object)this.serializer.serialize((Object)parameterName), (Object)this.serializer.serialize((Object)targetPath), (Object)this.serializer.serialize((Object)ignoreCache)));
        return (ValueResolverResult)this.serializer.deserialize(result);
    }

    public MetadataResult<ComponentMetadataTypesDescriptor> resolveComponentMetadata(ComponentElementDeclaration componentElementDeclaration, boolean ignoreCache) {
        String result = (String)this.dispatcher.dispatchRemoteMethod("resolveComponentMetadata", (List<Class>)ImmutableList.of(ComponentElementDeclaration.class, Boolean.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)componentElementDeclaration), (Object)this.serializer.serialize((Object)ignoreCache)));
        return (MetadataResult)this.serializer.deserialize(result);
    }

    public ComponentSampleDataResult getSampleData(ComponentElementDeclaration componentElementDeclaration) {
        String result = (String)this.dispatcher.dispatchRemoteMethod("getSampleData", (List<Class>)ImmutableList.of(ComponentElementDeclaration.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)componentElementDeclaration)));
        return (ComponentSampleDataResult)this.serializer.deserialize(result);
    }

    public ConnectionValidationResult testConnection(String configName) {
        String result = (String)this.dispatcher.dispatchRemoteMethod("testConnection", (List<Class>)ImmutableList.of(String.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)configName)));
        return (ConnectionValidationResult)this.serializer.deserialize(result);
    }

    public DeclarationSessionCacheService getCacheService() {
        return new DeclarationSessionCacheServiceWrapper(this.dispatcher.newReflectionInvoker(this.dispatcher.dispatchRemoteMethod("getCacheService")), this.serializer);
    }

    public void dispose() {
        this.dispatcher.dispatchRemoteMethod("dispose");
    }

    public static class Builder
    implements DeclarationSession.Builder {
        private final Dispatcher dispatcher;
        private final Serializer serializer;

        public Builder(Dispatcher dispatcher, Serializer serializer, ClassLoader toolingClassLoader) {
            Objects.requireNonNull(dispatcher, "dispatcher cannot be null");
            Objects.requireNonNull(serializer, "serializer cannot be null");
            Objects.requireNonNull(toolingClassLoader, "classloader cannot be null");
            this.dispatcher = dispatcher;
            this.serializer = serializer;
        }

        public DeclarationSession.Builder withConfigurationElementDeclarations(List<ConfigurationElementDeclaration> configurationElementDeclarations) {
            this.dispatcher.dispatchRemoteMethod("withConfigurationElementDeclarations", Arrays.asList(List.class), Arrays.asList(this.serializer.serialize(configurationElementDeclarations)));
            return this;
        }

        public DeclarationSession.Builder withGlobalParameters(List<TopLevelParameterDeclaration> globalParameterDeclarations) {
            this.dispatcher.dispatchRemoteMethod("withGlobalParameters", Arrays.asList(List.class), Arrays.asList(this.serializer.serialize(globalParameterDeclarations)));
            return this;
        }

        public DeclarationSession.Builder withSessionProperties(Map<String, String> sessionProperties) {
            this.dispatcher.dispatchRemoteMethod("withSessionProperties", Arrays.asList(Map.class), Arrays.asList(this.serializer.serialize(sessionProperties)));
            return this;
        }

        public DeclarationSession.Builder withDependency(Dependency dependency) {
            this.dispatcher.dispatchRemoteMethod("withDependency", Arrays.asList(Dependency.class), Arrays.asList(this.serializer.serialize((Object)dependency)));
            return this;
        }

        public DeclarationSession.Builder withCacheStorage(CacheStorage cacheStorage) {
            CacheStorageMapWrapper storageMap = new CacheStorageMapWrapper(cacheStorage);
            Method method = this.dispatcher.findMethod("internalWithCacheStorage");
            this.dispatcher.invoke(method, -1L, new Object[]{storageMap});
            return this;
        }

        public DeclarationSession build() {
            return new DeclarationSessionWrapper(this.dispatcher.newReflectionInvoker(this.dispatcher.dispatchRemoteMethod("build")), this.serializer);
        }
    }
}

