/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.aether;

import static java.lang.System.getProperty;

import org.eclipse.aether.impl.UpdateCheckManager;
import org.mule.maven.client.internal.AetherServiceRegister;
import org.mule.tooling.client.aether.concurrency.LockingFileProcessor;
import org.mule.tooling.client.aether.concurrency.LockingSyncContextFactory;

import io.takari.filemanager.FileManager;
import io.takari.filemanager.internal.DefaultFileManager;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.spi.io.FileProcessor;
import org.mule.tooling.client.aether.concurrency.ToolingUpdateCheckManagerAdapter;

/**
 * Implementation of {@link AetherServiceRegister} to register Takari's concurrent local repository implementation.
 *
 * @since 4.0
 */
public class ToolingAetherServiceRegister implements AetherServiceRegister {

  private static String TOOLING_CONCURRENT_LOCAL_REPOSITORY_ENABLED = "tooling.concurrent.local.repository.enabled";
  private Boolean concurrentLocalRepositoryEnabled =
      Boolean.valueOf(getProperty(TOOLING_CONCURRENT_LOCAL_REPOSITORY_ENABLED, "true"));

  @Override
  public void registerServices(DefaultServiceLocator serviceLocator) {
    if (concurrentLocalRepositoryEnabled) {
      serviceLocator.setService(UpdateCheckManager.class, ToolingUpdateCheckManagerAdapter.class);
      serviceLocator.setService(FileManager.class, DefaultFileManager.class);
      serviceLocator.setService(SyncContextFactory.class, LockingSyncContextFactory.class);
      serviceLocator.setService(FileProcessor.class, LockingFileProcessor.class);
    }
  }

}
