/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.aether.concurrency;

import static java.lang.String.format;
import static java.util.Objects.requireNonNull;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import io.takari.filemanager.FileManager;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;

/**
 * Implementation to allow the usage of {@link io.takari.aether.concurrency.LockingFileProcessor} in Aether without
 * dependency injection.
 *
 * @since 1.0
 */
public class LockingFileProcessor implements FileProcessor, Service {

  private io.takari.aether.concurrency.LockingFileProcessor lockingFileProcessor;

  @Override
  public void initService(ServiceLocator locator) {
    final FileManager fileManager = locator.getService(FileManager.class);
    requireNonNull(fileManager, format("%s has to be registered in ServiceLocator", FileManager.class.getName()));

    lockingFileProcessor = new io.takari.aether.concurrency.LockingFileProcessor(fileManager);
  }

  @Override
  public boolean mkdirs(File directory) {
    return lockingFileProcessor.mkdirs(directory);
  }

  @Override
  public void write(File target, String data) throws IOException {
    lockingFileProcessor.write(target, data);
  }

  @Override
  public void write(File target, InputStream source) throws IOException {
    lockingFileProcessor.write(target, source);
  }

  @Override
  public void move(File source, File target) throws IOException {
    lockingFileProcessor.move(source, target);
  }

  @Override
  public void copy(File source, File target) throws IOException {
    lockingFileProcessor.copy(source, target);
  }

  @Override
  public long copy(File source, File target, ProgressListener listener) throws IOException {
    return lockingFileProcessor.copy(source, target, listener);
  }

}
