/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.aether.concurrency;

import io.takari.aether.localrepo.TakariUpdateCheckManager;
import org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;

/**
 * Adapter that sets the dependency for the {@link UpdatePolicyAnalyzer} on {@link TakariUpdateCheckManager} as
 * {@link javax.inject.Inject} is not support when using Aether without Maven.
 *
 * @since 1.1
 */
public class ToolingUpdateCheckManagerAdapter extends TakariUpdateCheckManager implements Service {

  @Override
  public void initService(ServiceLocator serviceLocator) {
    setUpdatePolicyAnalyzer(serviceLocator.getService(UpdatePolicyAnalyzer.class));
  }

}
