/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Base64Encoder;
import org.codehaus.plexus.util.IOUtil;

public class Signer {
    private String secretKey;

    public Signer(String secretKey) {
        this.secretKey = secretKey;
    }

    public String generateSignature(File file) {
        byte[] data = this.readFile(file);
        try {
            SecretKeySpec secretKey = new SecretKeySpec(this.secretKey.getBytes("UTF-8"), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(secretKey);
            byte[] hmacData = mac.doFinal(data);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            new Base64Encoder().encode(hmacData, 0, hmacData.length, (OutputStream)bout);
            return bout.toString("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create signature for " + file.getName(), e);
        }
    }

    private byte[] readFile(File file) {
        byte[] byArray;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] fileContent = new byte[(int)file.length()];
            fileInputStream.read(fileContent);
            byArray = fileContent;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Could not read " + file.getName(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fileInputStream);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)fileInputStream);
        return byArray;
    }
}

