/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.StringUtils;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.mule.Signer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@MojoGoal(value="sign-us")
public class SignUpdateSiteMojo
extends AbstractMojo {
    private static final String SIGNATURE_FILE_NAME = "security.properties";
    private static final String CATEGORY = "org.eclipse.equinox.p2.type.category";
    private static final String CATEGORY_NAME = "org.eclipse.equinox.p2.name";
    private static final String DEVKIT_VERSION_PROPERTY = "mule.devkit.version";
    private static final String KEYSTORE_FILE_NAME = "keystore.ks";
    private static List<String> acceptedCategories = Arrays.asList("Community", "Premium", "Standard", "Select");
    private static List<String> acceptedPackaging = Arrays.asList("mule-module", "eclipse-repository");
    private static List<String> signingExclusions = Arrays.asList("security.properties");
    @MojoParameter(expression="${project}")
    private MavenProject project;
    @MojoParameter(expression="${signature.key}")
    private String signatureKey;
    @MojoParameter(expression="${licensePath}")
    private String licensePath;
    @MojoParameter(expression="${keystore.path}")
    private String keystorePath;

    public void execute() throws MojoExecutionException {
        try {
            if (!acceptedPackaging.contains(this.project.getPackaging())) {
                this.getLog().info((CharSequence)String.format("Skipping update-site for project %s because packaging is %s", this.project.getName(), this.project.getPackaging()));
                return;
            }
            String localUpdateSite = this.project.getBuild().getDirectory() + File.separator + "update-site" + File.separator;
            Document updateSiteContent = SignUpdateSiteMojo.loadUpdateSiteContent(new FileInputStream(new File(localUpdateSite + "content.xml")));
            String category = this.getCategoryName(updateSiteContent);
            this.checkAcceptedCategory(category);
            this.checkKeystoreAndLicense();
            Properties properties = this.initProperties();
            this.buildZip(localUpdateSite, properties);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Could not read file content.xml");
        }
    }

    private Properties initProperties() {
        Properties properties = new Properties();
        properties.setProperty("mule.version", this.getMuleVersion(this.project));
        return properties;
    }

    private String getMuleVersion(MavenProject project) {
        String muleVersion = project.getProperties().getProperty(DEVKIT_VERSION_PROPERTY);
        if (StringUtils.isBlank((String)muleVersion)) {
            MavenProject parent = project.getParent();
            if (parent != null) {
                return this.getMuleVersion(parent);
            }
            throw new IllegalArgumentException(String.format("Mandatory property %s was not speficied for groupId: %s, artifactId: %s, version:%s. Please add the property to your pom file and try again", DEVKIT_VERSION_PROPERTY, project.getGroupId(), project.getArtifactId(), project.getVersion()));
        }
        if (muleVersion.equalsIgnoreCase("LATEST")) {
            throw new IllegalArgumentException(String.format("LATEST is not allowed as value for the %s property. Please provide a specific version and try again", DEVKIT_VERSION_PROPERTY));
        }
        return muleVersion;
    }

    private void checkKeystoreAndLicense() throws MojoExecutionException {
        if (!this.hasAlicense() || !this.hasAKeystore()) {
            throw new MojoExecutionException("You must provide a license AND a keystore");
        }
    }

    private boolean hasAKeystore() {
        return this.fileExists(this.keystorePath) || this.baseFileExists(KEYSTORE_FILE_NAME);
    }

    private boolean baseFileExists(String path) {
        return new File(this.project.getBasedir() + File.separator + path).exists();
    }

    private boolean hasAlicense() {
        return this.fileExists(this.licensePath) || this.baseFileExists("studio_license.txt");
    }

    private boolean fileExists(Object path) {
        return path != null && new File((String)path).exists();
    }

    private void checkAcceptedCategory(String category) throws MojoExecutionException {
        if (!acceptedCategories.contains(category)) {
            throw new MojoExecutionException("Category is invalid. Accepted values " + acceptedCategories + " . Actual + " + category);
        }
    }

    private String getCategoryName(Document document) {
        NodeList properties = document.getElementsByTagName("property");
        for (int i = 0; i < properties.getLength(); ++i) {
            Node property = properties.item(i);
            if (!this.getNameOf(property).equals(CATEGORY)) continue;
            Node parentNode = property.getParentNode();
            NodeList childs = parentNode.getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                Node item = childs.item(j);
                if (item.getAttributes() == null || !this.getNameOf(item).equals(CATEGORY_NAME)) continue;
                return item.getAttributes().getNamedItem("value").getNodeValue();
            }
        }
        return null;
    }

    private String getNameOf(Node property) {
        return property.getAttributes().getNamedItem("name").getNodeValue();
    }

    private File buildZip(String localUpdateSite, Properties properties) throws ArchiverException, MojoExecutionException {
        ZipArchiver archiver = new ZipArchiver();
        File updateSiteDir = new File(localUpdateSite);
        Signer signer = new Signer(this.signatureKey);
        File[] filesToZip = updateSiteDir.listFiles();
        if (filesToZip == null) {
            throw new MojoExecutionException("No files found for signing under " + localUpdateSite);
        }
        for (File file : filesToZip) {
            String name = file.getName();
            if (signingExclusions.contains(name)) continue;
            this.addToUpdateSiteZip(properties, archiver, signer, file, name);
        }
        this.signUpdateSite(archiver, updateSiteDir, properties);
        File destFile = new File(this.project.getBuild().getDirectory() + File.separator + "UpdateSite.zip");
        archiver.setDestFile(destFile);
        try {
            destFile.delete();
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return destFile;
    }

    private void addToUpdateSiteZip(Properties properties, ZipArchiver archiver, Signer signer, File file, String name) {
        if (file.isDirectory()) {
            archiver.addDirectory(file, name + File.separator);
        } else {
            properties.setProperty(name, signer.generateSignature(file));
            archiver.addFile(file, name);
        }
    }

    private void signUpdateSite(ZipArchiver archiver, File updateSiteDir, Properties properties) throws MojoExecutionException {
        try {
            File file = new File(updateSiteDir.getAbsolutePath() + File.separator + SIGNATURE_FILE_NAME);
            properties.store(new FileOutputStream(file), null);
            archiver.addFile(file, file.getName());
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Could not sign the Update Site");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not sign the Update Site");
        }
    }

    private static Document loadUpdateSiteContent(InputStream in) throws MojoExecutionException {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Document ret = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error parsing document", e);
        }
        try {
            ret = builder.parse(new InputSource(in));
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Could not parse content.xml");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not parse content.xml");
        }
        return ret;
    }
}

