/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.api.request.values;

import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;

public final class FieldValuesRequest {

  private final String providerName;
  private final ComponentElementDeclaration<?> componentElementDeclaration;
  private final String targetSelector;

  public FieldValuesRequest(ComponentElementDeclaration<?> componentElementDeclaration, String providerName,
                            String targetSelector) {
    this.componentElementDeclaration = componentElementDeclaration;
    this.providerName = providerName;
    this.targetSelector = targetSelector;
  }

  public String getProviderName() {
    return providerName;
  }

  public String getTargetSelector() {
    return targetSelector;
  }

  public ComponentElementDeclaration<?> getComponentElementDeclaration() {
    return componentElementDeclaration;
  }
}
