/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.internal.serialization.json;

import com.google.gson.Gson;
import org.mule.tooling.api.serialization.Serializer;

/**
 * {@link Serializer} implementation that serializes to Json format.
 */
public class JsonSerializer implements Serializer {

  private final Gson gson;

  public JsonSerializer(Gson gson) {
    this.gson = gson;
  }

  @Override
  public <T> String serialize(T object) {
    return gson.toJson(object);
  }

  @Override
  public <T> T deserialize(String serializedValue, Class<T> clazz) {
    return gson.fromJson(serializedValue, clazz);
  }
}
