/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.api.request.values;

import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.Optional.ofNullable;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;

import java.util.Optional;

/**
 * Request to resolve set of values for a given parameter of a component.
 */
public final class ValuesRequest {

  private ConfigurationElementDeclaration configurationElementDeclaration;
  private ConnectionElementDeclaration connectionElementDeclaration;
  private ComponentElementDeclaration componentElementDeclaration;
  private final String providerName;

  public ValuesRequest(String providerName) {
    this.providerName = providerName;
  }

  public ValuesRequest(ConfigurationElementDeclaration configurationElementDeclaration,
                       String providerName) {
    this(providerName);
    this.configurationElementDeclaration = configurationElementDeclaration;
  }

  public ValuesRequest(ConnectionElementDeclaration connectionElementDeclaration,
                       String providerName) {
    this(providerName);
    this.connectionElementDeclaration = connectionElementDeclaration;
  }

  public ValuesRequest(ComponentElementDeclaration componentElementDeclaration,
                       String providerName) {
    this(providerName);
    this.componentElementDeclaration = componentElementDeclaration;
  }

  public Optional<ConfigurationElementDeclaration> getConfigurationElementDeclaration() {
    return ofNullable(configurationElementDeclaration);
  }

  public Optional<ConnectionElementDeclaration> getConnectionElementDeclaration() {
    return ofNullable(connectionElementDeclaration);
  }

  public Optional<ComponentElementDeclaration> getComponentElementDeclaration() {
    return ofNullable(componentElementDeclaration);
  }

  public Optional<ParameterizedElementDeclaration> getParameterizedElementDeclaration() {
    if (getConfigurationElementDeclaration().isPresent()) {
      return of(getConfigurationElementDeclaration().get());
    }
    if (getConnectionElementDeclaration().isPresent()) {
      return of(getConnectionElementDeclaration().get());
    }
    if (getComponentElementDeclaration().isPresent()) {
      return of(getComponentElementDeclaration().get());
    }
    return empty();
  }

  public String getProviderName() {
    return providerName;
  }
}
