/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.service.artifact;

import javax.inject.Named;
import javax.inject.Singleton;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.sampledata.SampleDataFailure;
import org.mule.runtime.api.sampledata.SampleDataResult;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.tooling.api.service.artifact.DeployableArtifactAgentService;
import org.mule.tooling.internal.service.AbstractConfigurableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="org.mule.tooling.service.artifact")
@Singleton
public class DefaultDeployableArtifactAgentService
extends AbstractConfigurableService
implements DeployableArtifactAgentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDeployableArtifactAgentService.class);

    @Override
    public SampleDataResult getSampleData(Application application, Location location) {
        try {
            return SampleDataResult.resultFrom((Message)application.getSampleDataService().getSampleData(location));
        }
        catch (SampleDataException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(String.format("Get sample data has FAILED with code: %s for location: %s", e.getFailureCode(), location), (Throwable)e);
            }
            return SampleDataResult.resultFrom((SampleDataFailure)SampleDataFailure.Builder.newFailure((Throwable)e).withFailureCode(e.getFailureCode()).build());
        }
        catch (Exception e) {
            return SampleDataResult.resultFrom((SampleDataFailure)SampleDataFailure.Builder.newFailure((Throwable)e).withMessage("Unknown error occurred trying to resolve sample data. " + e.getMessage()).withFailureCode("UNKNOWN").build());
        }
    }
}

