/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.api.service.artifact;

import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.sampledata.SampleDataResult;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.sdk.api.data.sample.SampleDataException;

/**
 * Service that handles requests on a {@link org.mule.runtime.deployment.model.api.DeployableArtifact}
 *
 * @since 4.4.0
 */
public interface DeployableArtifactAgentService {

  /**
   * Resolves the {@link SampleDataResult result} for a component's sample data provider located in the given {@link Location}.
   *
   * @param application The target {@link Application} to be used in order to resolve sample data.
   * @param location    The {@link Location} where the configuration can be found.
   * @throws SampleDataException if resolution fails
   *
   * @return the {@link SampleDataResult result} of the resolving of the sample data.
   * @see SampleDataResult
   */
  SampleDataResult getSampleData(Application application, Location location);

}
