/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.internal.configuration.guice;

import com.google.inject.Binder;
import com.mulesoft.agent.configuration.guice.BaseModuleProvider;

import org.mule.tooling.api.service.Configuration;
import org.mule.tooling.api.service.expression.RuntimeAgentService;
import org.mule.tooling.api.service.session.DeclarationSessionAgentService;
import org.mule.tooling.api.service.artifact.DeployableArtifactAgentService;
import org.mule.tooling.internal.handler.sampledata.SampleDataServiceAgentHandler;
import org.mule.tooling.internal.service.DefaultConfiguration;
import org.mule.tooling.internal.service.expression.DefaultRuntimeAgentService;
import org.mule.tooling.internal.service.session.DefaultDeclarationSessionAgentService;
import org.mule.tooling.internal.handler.session.DeclarationSessionsAgentHandler;
import org.mule.tooling.internal.service.artifact.DefaultDeployableArtifactAgentService;

public class ToolingAgentPluginModuleProvider extends BaseModuleProvider {

  @Override
  protected void configureModule(Binder binder) {
    bindService(binder, DeclarationSessionAgentService.class, DefaultDeclarationSessionAgentService.class);
    bindService(binder, DeployableArtifactAgentService.class, DefaultDeployableArtifactAgentService.class);
    bindService(binder, Configuration.class, DefaultConfiguration.class);
    bindService(binder, RuntimeAgentService.class, DefaultRuntimeAgentService.class);
    bindExternalHandler(binder, DeclarationSessionsAgentHandler.class);
    bindExternalHandler(binder, SampleDataServiceAgentHandler.class);
  }
}
