/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.internal.service.artifact;

import static java.lang.String.format;
import static org.mule.runtime.api.sampledata.SampleDataFailure.Builder.newFailure;
import static org.mule.runtime.api.sampledata.SampleDataResult.resultFrom;
import static org.mule.runtime.extension.api.values.ValueResolvingException.UNKNOWN;
import static org.slf4j.LoggerFactory.getLogger;

import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.sampledata.SampleDataResult;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.tooling.api.service.artifact.DeployableArtifactAgentService;
import org.mule.tooling.internal.service.AbstractConfigurableService;

import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;

/**
 * Default implementation for {@link DeployableArtifactAgentService}
 */
@Named("org.mule.tooling.service.artifact")
@Singleton
public class DefaultDeployableArtifactAgentService extends AbstractConfigurableService implements DeployableArtifactAgentService {

  private static final Logger LOGGER = getLogger(DefaultDeployableArtifactAgentService.class);

  @Override
  public SampleDataResult getSampleData(Application application, Location location) {
    try {
      return resultFrom(application.getSampleDataService().getSampleData(location));
    } catch (SampleDataException e) {
      if (LOGGER.isWarnEnabled()) {
        LOGGER.warn(format("Get sample data has FAILED with code: %s for location: %s", e.getFailureCode(),
                           location),
                    e);
      }
      return resultFrom(newFailure(e).withFailureCode(e.getFailureCode()).build());
    } catch (Exception e) {
      return resultFrom(newFailure(e)
          .withMessage("Unknown error occurred trying to resolve sample data. " + e.getMessage())
          .withFailureCode(UNKNOWN)
          .build());
    }
  }
}
