/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.internal.service.expression;

import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.tooling.api.service.expression.RuntimeAgentService;
import org.mule.tooling.internal.service.AbstractConfigurableService;

import java.util.List;
import java.util.Optional;

import javax.inject.Named;
import javax.inject.Singleton;

@Named("org.mule.tooling.service.runtime")
@Singleton
public class DefaultRuntimeAgentService extends AbstractConfigurableService implements RuntimeAgentService {

  private ServiceRepository serviceRepository;

  @Override
  public ExpressionLanguage getExpressionLanguage() {
    List<Service> services = serviceRepository.getServices();
    Optional<Service> service = services.stream().filter(s -> s instanceof DefaultExpressionLanguageFactoryService).findFirst();
    if (!service.isPresent()) {
      throw new IllegalStateException("DefaultExpressionLanguageFactoryService not found.");
    }
    return ((DefaultExpressionLanguageFactoryService) service.get()).create();
  }

  @Override
  public void setServiceRepository(ServiceRepository serviceRepository) {
    this.serviceRepository = serviceRepository;
  }
}
