/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.api.service.session;

import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.module.tooling.api.ArtifactAgnosticServiceBuilder;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * Internal service to provide functionalities to the {@link com.mulesoft.agent.handlers.ExternalMessageHandler}s
 */
public interface DeclarationSessionAgentService {

  DeclarationSessionContainer createDeclarationSession(List<ArtifactAgnosticServiceBuilder.Dependency> dependencies,
                                                       ArtifactDeclaration artifactDeclaration,
                                                       Map<String, String> sessionProperties);

  Optional<DeclarationSessionContainer> getSession(String id);

  boolean deleteSession(String id);
}
