/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.internal.handler;

import java.util.Optional;
import java.util.function.Supplier;

import org.slf4j.MDC;

public interface LoggingHandler {

  String REQUEST_ID_HEADER_NAME = "X-B3-TraceId";
  String MDC_TRACE_ID_KEY = "traceId";

  default <T> T withLoggingContext(Optional<String> requestIdHeader, Supplier<T> responseSupplier) {
    requestIdHeader.ifPresent(id -> MDC.put(MDC_TRACE_ID_KEY, id));
    try {
      return responseSupplier.get();
    } finally {
      MDC.remove(MDC_TRACE_ID_KEY);
    }
  }

}
