/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.internal.service;

import org.mule.tooling.api.service.Configuration;

import com.mulesoft.agent.configuration.Configurable;

import javax.inject.Named;
import javax.inject.Singleton;

@Named("org.mule.tooling.service.configuration")
@Singleton
public class DefaultConfiguration extends AbstractConfigurableService implements Configuration {

  @Configurable("1048576") // 1MiB
  private Long sampleDataMaxPayloadSize;


  @Override
  public Long getSampleDataMaxPayloadSize() {
    return sampleDataMaxPayloadSize;
  }
}
